package com.bokesoft.yigo.meta.bpm.process.monitor;

import java.util.LinkedList;

import com.bokesoft.yigo.common.def.MonitorScopeType;
import com.bokesoft.yigo.meta.base.AbstractMetaObject;
import com.bokesoft.yigo.meta.base.IMetaEnv;
import com.bokesoft.yigo.meta.base.MetaException;

public class MetaMonitor extends AbstractMetaObject {
	public static final String TAG_NAME = "Monitor";
	
	/** 监控的事件类型*/
	private Integer type = -1;
	/** 监控器的有效范围*/
	private Integer scope = MonitorScopeType.GLOBAL;
	/** 记录器的集合*/
	private String loggers = "";
	/** 流程范围内监控*/
	private MetaWorkflowScope workflowScope = null;
	/** 节点范围内监控*/
	private MetaNodeScope nodeScope = null;
	
	public Integer getType() {
		return type;
	}

	public void setType(Integer type) {
		this.type = type;
	}

	public Integer getScope() {
		return scope;
	}

	public void setScope(Integer scope) {
		this.scope = scope;
	}

	public String getLoggers() {
		return loggers;
	}

	public void setLoggers(String loggers) {
		this.loggers = loggers;
	}

	@Override
	public void getChildMetaObjects(LinkedList<Object> list) {
		if (workflowScope != null)
			list.add(workflowScope);
		if (nodeScope != null)
			list.add(nodeScope);

	}

	@Override
	public String getTagName() {
		return TAG_NAME;
	}
	
	/**
	 * 设置流程范围内监控集合
	 * 
	 * @param workflowScope 流程范围内监控集合
	 *            
	 */
	public void setWorkflowScope(MetaWorkflowScope workflowScope) {
		this.workflowScope = workflowScope;
	}

	/**
	 * 取得流程范围内监控集合
	 * 
	 * @return 流程范围内监控集合
	 */
	public MetaWorkflowScope getWorkflowScope() {
		return this.workflowScope;
	}
	
	/**
	 * 设置节点范围内监控
	 * 
	 * @param nodeScope 节点范围内监控
	 *            
	 */
	public void setNodeScope(MetaNodeScope nodeScope) {
		this.nodeScope = nodeScope;
	}

	/**
	 * 取得节点范围内监控
	 * 
	 * @return 节点范围内监控
	 */
	public MetaNodeScope getNodeScope() {
		return this.nodeScope;
	}

	@Override
	public AbstractMetaObject createChildMetaObject(IMetaEnv env, Object doc, Object node, String tagName, Object flag,
			int runType) throws MetaException {
		AbstractMetaObject resultMetaObject = null;
		if (MetaWorkflowScope.TAG_NAME.equals(tagName)) {
			this.workflowScope = new MetaWorkflowScope();
			resultMetaObject = this.workflowScope;
		} else if (MetaNodeScope.TAG_NAME.equals(tagName)) {
			this.nodeScope = new MetaNodeScope();
			resultMetaObject = this.nodeScope;
		}
		return resultMetaObject;
	}

	@Override
	public AbstractMetaObject clone() {
		MetaMonitor newObj = new MetaMonitor();
		newObj.type = type;
		newObj.scope = scope;
		newObj.loggers = loggers;
		newObj.setWorkflowScope(workflowScope == null ? null : (MetaWorkflowScope) workflowScope.clone());
		newObj.setNodeScope(nodeScope == null ? null : (MetaNodeScope) nodeScope.clone());
		return newObj;
	}

	@Override
	public AbstractMetaObject newInstance() {
		return new MetaMonitor();
	}

}
