package com.bokesoft.yigo.meta.bpm.process.message;

import java.util.LinkedList;

import com.bokesoft.yigo.meta.base.AbstractMetaObject;
import com.bokesoft.yigo.meta.base.IMetaEnv;
import com.bokesoft.yigo.meta.base.MetaException;

public class MetaProducer extends AbstractMetaObject {

	public static final String TAG_NAME = "Producer";
	
	/** 消息发送目的地 */
	private String destination= "";
	/** 自定义消息发送*/
	private String messageSendImpl= "";
	/** 重发次数*/
	private Integer resendTimes = 0;
	/** 消息超时设置*/
	private Long timeout = -1L;
	

	public String getDestination() {
		return destination;
	}

	public void setDestination(String destination) {
		this.destination = destination;
	}
	
	public Integer getResendTimes() {
		return resendTimes;
	}
	
	public void setResendTimes(Integer resendTimes) {
		this.resendTimes = resendTimes;
	}
	
	public Long getTimeout() {
		return timeout;
	}
	
	public void setTimeout(Long timeout) {
		this.timeout = timeout;
	}

	public String getMessageSendImpl() {
		return messageSendImpl;
	}

	public void setMessageSendImpl(String messageSendImpl) {
		this.messageSendImpl = messageSendImpl;
	}
	
	@Override
	public AbstractMetaObject clone() {
		MetaProducer obj = (MetaProducer)newInstance();
		obj.destination = destination;
		obj.messageSendImpl = messageSendImpl;
		obj.resendTimes = resendTimes;
		obj.timeout = timeout;
		return obj;
	}
	
	@Override
	public AbstractMetaObject createChildMetaObject(IMetaEnv env, Object doc, Object node, String tagName, Object flag,
			int runType) throws MetaException {
		// TODO Auto-generated method stub
		return null;
	}
	
	@Override
	public void getChildMetaObjects(LinkedList<Object> list) {
		// TODO Auto-generated method stub
		
	}
	
	@Override
	public String getTagName() {
		return TAG_NAME;
	}
	
	@Override
	public AbstractMetaObject newInstance() {
		return new MetaProducer();
	}
}
