package com.bokesoft.yigo.meta.bpm.process.attribute.participator;

import java.util.LinkedList;

import org.json.JSONObject;

import com.bokesoft.yes.common.json.SerializationException;
import com.bokesoft.yigo.meta.base.AbstractMetaObject;
import com.bokesoft.yigo.meta.base.IMetaEnv;
import com.bokesoft.yigo.meta.base.MetaException;

public class MetaQueryParameter extends AbstractMetaObject {

	public static final String TAG_NAME = "QueryParameter";

	/** 参数的数据类型 */
	private Integer dataType = -1;

	/** 参数的来源公式 */
	private String formula = "";

	@Override
	public void getChildMetaObjects(LinkedList<Object> list) {
	}

	@Override
	public String getTagName() {
		return TAG_NAME;
	}

	@Override
	public AbstractMetaObject createChildMetaObject(IMetaEnv env, Object doc, Object node, String tagName, Object flag, int runType) throws MetaException {
		return null;
	}

	@Override
	public AbstractMetaObject clone() {
		MetaQueryParameter newQueryParameter = (MetaQueryParameter) newInstance();
		newQueryParameter.setDataType(dataType);
		newQueryParameter.setFormula(formula);
		return newQueryParameter;
	}

	@Override
	public AbstractMetaObject newInstance() {
		return new MetaQueryParameter();
	}

	public Integer getDataType() {
		return dataType;
	}

	public void setDataType(Integer dataType) {
		this.dataType = dataType;
	}

	public String getFormula() {
		return formula;
	}

	public void setFormula(String formula) {
		this.formula = formula;
	}
	
	@Override
	public JSONObject toJSON() throws SerializationException {
		JSONObject obj = new JSONObject();
		obj.put("dataType", dataType);
		obj.put("formula", formula);
		return obj;
	}
	
	@Override
	public void fromJSON(JSONObject json) throws SerializationException {
		dataType = json.optInt("dataType");
		formula = json.optString("formula");
	}

}
