package com.bokesoft.yigo.meta.bpm.process.attribute.participator;

import java.util.LinkedList;

import org.json.JSONObject;

import com.bokesoft.yes.common.json.SerializationException;
import com.bokesoft.yigo.meta.base.AbstractMetaObject;
import com.bokesoft.yigo.meta.base.IMetaEnv;
import com.bokesoft.yigo.meta.base.MetaException;

public class MetaExternalLink extends Participator {

	public final static String TAG_NAME = "ExternalLink";
	
	private String sourceKey = "";
	private MetaSourceParaCollection metaSourceParaCollection = null;
	
	public void setSourceKey(String sourceKey) {
		this.sourceKey = sourceKey;
	}
	
	public String getSourceKey() {
		return sourceKey;
	}
	
	public void setSourceParaCollection(MetaSourceParaCollection metaSourceParaCollection) {
		this.metaSourceParaCollection = metaSourceParaCollection;
	}
	
	public MetaSourceParaCollection getSourceParaCollection() {
		return metaSourceParaCollection;
	}
	
	public void getChildMetaObjects(LinkedList<Object> list) {
		addAll(list, new AbstractMetaObject[] { metaSourceParaCollection });
	}
	
	public AbstractMetaObject createChildMetaObject(IMetaEnv env, Object doc, Object node, String tagName, Object flag, int runType) throws MetaException {
		AbstractMetaObject resultMetaObject = null;
		if (tagName.equalsIgnoreCase(MetaSourceParaCollection.TAG_NAME)) {
			metaSourceParaCollection = new MetaSourceParaCollection();
			resultMetaObject = metaSourceParaCollection;
			resultMetaObject.preProcessMetaObject(env, doc, node, flag, runType);
		}
		return resultMetaObject;
	}
	
	@Override
	public AbstractMetaObject clone() {
		MetaExternalLink metaExternalLink = (MetaExternalLink)newInstance();
		metaExternalLink.setSourceKey(sourceKey);
		metaExternalLink.setSourceParaCollection(metaSourceParaCollection == null ? null : (MetaSourceParaCollection) metaSourceParaCollection.clone());
		return metaExternalLink;
	}
	
	@Override
	public String getTagName() {
		return TAG_NAME;
	}
	
	@Override
	public AbstractMetaObject newInstance() {
		return new MetaExternalLink();
	}
	
	@Override
	public JSONObject toJSON() throws SerializationException {
		JSONObject obj = new JSONObject();
		obj.put("sourceKey", sourceKey);
		if(metaSourceParaCollection != null) {
			obj.put("metaSourceParaCollection", metaSourceParaCollection);
		}
		return obj;
	}
	
	@Override
	public void fromJSON(JSONObject json) throws SerializationException {
		sourceKey = json.optString("sourceKey");
		if (json.has("metaSourceParaCollection")) {
			metaSourceParaCollection = new MetaSourceParaCollection();
			metaSourceParaCollection.fromJSON(json.getJSONObject("metaSourceParaCollection"));
		}
	}
}
