package com.bokesoft.yigo.meta.bpm.process.attribute;

import java.util.Iterator;
import java.util.Map.Entry;

import org.json.JSONArray;
import org.json.JSONObject;

import com.bokesoft.yigo.meta.base.AbstractMetaObject;
import com.bokesoft.yigo.meta.bpm.AbstractBPMCollection;

public class MetaOperationCollection extends AbstractBPMCollection<MetaBPMOperation> {

	public final static String TAG_NAME = "OperationCollection";

	@Override
	public String getTagName() {
		return TAG_NAME;
	}

	@Override
	public AbstractMetaObject newInstance() {
		return new MetaOperationCollection();
	}

	@Override
	protected MetaBPMOperation createChildMetaElement(String tagName) {
		MetaBPMOperation child = null;
		if (tagName.equalsIgnoreCase(MetaBPMOperation.TAG_NAME))
			child = new MetaBPMOperation();
		if (tagName.equalsIgnoreCase(MetaBPMOperationExternalLink.TAG_NAME))
			child = new MetaBPMOperationExternalLink();
		return child;
	}

	@Override
	public JSONObject toJSON() {
		JSONObject obj = new JSONObject();
		JSONArray operationArray = new JSONArray();
		Iterator<Entry<String, MetaBPMOperation>> it = this.elementMap.entrySet().iterator();
		Entry<String, MetaBPMOperation> entry = null;
		MetaBPMOperation operation = null;
		while ( it.hasNext() ) {
			entry = it.next();
			operation = entry.getValue();
			operationArray.put(operation.toJSON());
		}
		obj.put("items", operationArray);
		
		return obj;
	}

	@Override
	public void fromJSON(JSONObject json) {
		if ( json.has("items") ) {
			JSONArray operationArray = json.getJSONArray("items");
			for ( int i = 0, size = operationArray.length(); i<size; ++i ) {
				JSONObject operationObj = operationArray.getJSONObject(i);
				MetaBPMOperation operation = new MetaBPMOperation();
				operation.fromJSON(operationObj);
				this.add(operation);
			}
		}
	}

}
