package com.bokesoft.yigo.meta.bpm.process.attribute;

import java.util.Iterator;

import org.json.JSONArray;
import org.json.JSONObject;

import com.bokesoft.yigo.meta.base.AbstractMetaObject;
import com.bokesoft.yigo.meta.bpm.AbstractBPMNoKeyCollection;

public class MetaBillDataMapInfoCollection extends AbstractBPMNoKeyCollection<MetaBillDataMapInfo> {

	public static final String TAG_NAME = "BillDataMapInfoCollection";

	@Override
	protected MetaBillDataMapInfo createChildMetaElement(String tagName) {
		MetaBillDataMapInfo child = null;
		if (tagName.equalsIgnoreCase(MetaBillDataMapInfo.TAG_NAME)) {
			child = new MetaBillDataMapInfo();
		}
		return child;
	}

	@Override
	public String getTagName() {
		return TAG_NAME;
	}

	@Override
	public AbstractMetaObject newInstance() {
		return new MetaBillDataMapInfoCollection();
	}

	@Override
	public JSONObject toJSON() {
		JSONObject obj = new JSONObject();
		JSONArray dataMapInfoArray = new JSONArray();
		Iterator<MetaBillDataMapInfo> it = this.elementArray.iterator();
		MetaBillDataMapInfo dataMapInfo = null;
		while (it.hasNext()) {
			dataMapInfo = it.next();
			JSONObject dataMapInfoObj = dataMapInfo.toJSON();
			dataMapInfoArray.put(dataMapInfoObj);
		}
		obj.put("items", dataMapInfoArray);

		return obj;
	}

	@Override
	public void fromJSON(JSONObject json) {
		if (json.has("items")) {
			JSONArray dataMapInfoArray = json.getJSONArray("items");
			for (int i = 0, size = dataMapInfoArray.length(); i < size; ++i) {
				JSONObject dataMapInfoObj = dataMapInfoArray.getJSONObject(i);
				MetaBillDataMapInfo dataMapInfo = new MetaBillDataMapInfo();
				dataMapInfo.fromJSON(dataMapInfoObj);
				this.add(dataMapInfo);
			}
		}
	}

}
