package com.bokesoft.yigo.meta.bpm.process.attribute;

import java.util.Iterator;
import java.util.Map.Entry;

import org.json.JSONArray;
import org.json.JSONObject;

import com.bokesoft.yigo.meta.base.AbstractMetaObject;
import com.bokesoft.yigo.meta.bpm.AbstractBPMCollection;
import com.bokesoft.yigo.meta.bpm.process.node.MetaAudit;
import com.bokesoft.yigo.meta.bpm.process.node.MetaCountersign;
import com.bokesoft.yigo.meta.bpm.process.node.MetaNode;
import com.bokesoft.yigo.meta.bpm.process.node.MetaUserTask;

public class MetaAssistanceCollection extends AbstractBPMCollection<MetaNode> {

	public final static String TAG_NAME = "AssistanceCollection";

	@Override
	public String getTagName() {
		return TAG_NAME;
	}

	@Override
	public AbstractMetaObject newInstance() {
		return new MetaAssistanceCollection();
	}
	
	private MetaNode createAssitance(String tagName) {
		MetaNode child = null;
		if (tagName.equalsIgnoreCase(MetaAudit.TAG_NAME)) {
			child = new MetaAudit();
		} else if (tagName.equalsIgnoreCase(MetaCountersign.TAG_NAME)) {
			child = new MetaCountersign();
		} else if (tagName.equalsIgnoreCase(MetaUserTask.TAG_NAME)) {
			child = new MetaUserTask();
		}
		return child;
	}

	@Override
	protected MetaNode createChildMetaElement(String tagName) {
		MetaNode child = this.createAssitance(tagName);
		return child;
	}

	@Override
	public JSONObject toJSON() {
		JSONObject obj = new JSONObject();
		JSONArray assitanceArray = new JSONArray();
		Iterator<Entry<String, MetaNode>> it = this.elementMap.entrySet().iterator();
		Entry<String, MetaNode> entry = null;
		MetaNode assitance = null;
		while ( it.hasNext() ) {
			entry = it.next();
			assitance = entry.getValue();
			assitanceArray.put(assitance.toJSON());
		}
		obj.put("items", assitanceArray);
		
		return obj;
	}

	@Override
	public void fromJSON(JSONObject json) {
		if ( json.has("items") ) {
			JSONArray assitanceArray = json.getJSONArray("items");
			for ( int i = 0, size = assitanceArray.length(); i<size; ++i ) {
				JSONObject assitanceObj = assitanceArray.getJSONObject(i);
				String tagName = assitanceObj.getString("tag-name");
				MetaNode assitance = this.createAssitance(tagName);
				assitance.fromJSON(assitanceObj);
				this.add(assitance);
			}
		}
	}

}
