package com.bokesoft.yigo.meta.bpm.process.attribute;

public class LineStyle {

	/** 直线 */
	public static final int STEAIGHT_LINE = 0;

	/** 直线字符串表示 */
	public static final String STR_STEAIGHT_LINE = "StraightLine";

	/** 采用圆弧过度的直角折线箭头， 箭头为水平方向 */
	public static final int CHAMFER_CURVE_H_ONE = 1;

	/** 上述箭头字符串表示 */
	public static final String STR_CHAMFER_CURVE_H_ONE = "ChamferCurveHOne";

	/** 采用圆弧过度的直角折线箭头， 箭头为垂直方向 */
	public static final int CHAMFER_CURVE_V_ONE = 2;

	/** 上述箭头字符串表示 */
	public static final String STR_CHAMFER_CURVE_V_ONE = "ChamferCurveVOne";

	/** 采用圆弧过度的双直角折线箭头， 箭头为水平方向 */
	public static final int CHAMFER_CURVE_H_TWO = 3;

	/** 上述箭头字符串表示 */
	public static final String STR_CHAMFER_CURVE_H_TWO = "ChamferCurveHTwo";

	/** 采用圆弧过度的双直角折线箭头， 箭头为垂直方向 */
	public static final int CHAMFER_CURVE_V_TWO = 4;

	/** 上述箭头字符串表示 */
	public static final String STR_CHAMFER_CURVE_V_TWO = "ChamferCurveVTwo";

	/** 直角折线箭头， 箭头为水平方向 */
	public static final int FILLET_CURVE_H_ONE = 5;

	/** 上述箭头字符串表示 */
	public static final String STR_FILLET_CURVE_H_ONE = "FilletCurveHOne";

	/** 直角折线箭头， 箭头为垂直方向 */
	public static final int FILLET_CURVE_V_ONE = 6;

	/** 上述箭头字符串表示 */
	public static final String STR_FILLET_CURVE_V_ONE = "FilletCurveVOne";

	/** 两个直角折线的箭头， 箭头为水平方向 */
	public static final int FILLET_CURVE_H_TWO = 7;

	/** 上述箭头字符串表示 */
	public static final String STR_FILLET_CURVE_H_TWO = "FilletCurveHTwo";

	/** 两个直角折线的箭头， 箭头为垂直方向 */
	public static final int FILLET_CURVE_V_TWO = 8;

	/** 上述箭头字符串表示 */
	public static final String STR_FILLET_CURVE_V_TWO = "FilletCurveVTwo";

	/** 水平方向的三段折线箭头 */
	public static final int OBKIQUE_CURVE_H_TWO = 9;

	/** 上述箭头字符串表示 */
	public static final String STR_OBKIQUE_CURVE_H_TWO = "ObliqueCurveHTwo";

	/** 垂直方向的三段折线箭头 */
	public static final int OBKIQUE_CURVE_V_TWO = 10;

	/** 上述箭头字符串表示 */
	public static final String STR_OBKIQUE_CURVE_V_TWO = "ObliqueCurveVTwo";

	public static String formatLineStyleString(Integer type) {
		if(type == null)
			return "";
		
		switch (type) {
		case STEAIGHT_LINE:
			return STR_STEAIGHT_LINE;
		case CHAMFER_CURVE_H_ONE:
			return STR_CHAMFER_CURVE_H_ONE;
		case CHAMFER_CURVE_V_ONE:
			return STR_CHAMFER_CURVE_V_ONE;
		case CHAMFER_CURVE_H_TWO:
			return STR_CHAMFER_CURVE_H_TWO;
		case CHAMFER_CURVE_V_TWO:
			return STR_CHAMFER_CURVE_V_TWO;
		case FILLET_CURVE_H_ONE:
			return STR_FILLET_CURVE_H_ONE;
		case FILLET_CURVE_V_ONE:
			return STR_FILLET_CURVE_V_ONE;
		case FILLET_CURVE_H_TWO:
			return STR_FILLET_CURVE_H_TWO;
		case FILLET_CURVE_V_TWO:
			return STR_FILLET_CURVE_V_TWO;
		case OBKIQUE_CURVE_H_TWO:
			return STR_OBKIQUE_CURVE_H_TWO;
		case OBKIQUE_CURVE_V_TWO:
			return STR_OBKIQUE_CURVE_V_TWO;
		}
		return null;
	}

	public static int parseLineStyle(String s) {
		int type = -1;
		if (STR_STEAIGHT_LINE.equalsIgnoreCase(s)) {
			type = STEAIGHT_LINE;
		} else if (STR_CHAMFER_CURVE_H_ONE.equalsIgnoreCase(s)) {
			type = CHAMFER_CURVE_H_ONE;
		} else if (STR_CHAMFER_CURVE_V_ONE.equalsIgnoreCase(s)) {
			type = CHAMFER_CURVE_V_ONE;
		} else if (STR_CHAMFER_CURVE_H_TWO.equalsIgnoreCase(s)) {
			type = CHAMFER_CURVE_H_TWO;
		} else if (STR_CHAMFER_CURVE_V_TWO.equalsIgnoreCase(s)) {
			type = CHAMFER_CURVE_V_TWO;
		} else if (STR_FILLET_CURVE_H_ONE.equalsIgnoreCase(s)) {
			type = FILLET_CURVE_H_ONE;
		} else if (STR_FILLET_CURVE_V_ONE.equalsIgnoreCase(s)) {
			type = FILLET_CURVE_V_ONE;
		} else if (STR_FILLET_CURVE_H_TWO.equalsIgnoreCase(s)) {
			type = FILLET_CURVE_H_TWO;
		} else if (STR_FILLET_CURVE_V_TWO.equalsIgnoreCase(s)) {
			type = FILLET_CURVE_V_TWO;
		} else if (STR_OBKIQUE_CURVE_H_TWO.equalsIgnoreCase(s)) {
			type = OBKIQUE_CURVE_H_TWO;
		} else if (STR_OBKIQUE_CURVE_V_TWO.equalsIgnoreCase(s)) {
			type = OBKIQUE_CURVE_V_TWO;
		}
		return type;
	}
}
