package com.bokesoft.yigo.meta.archive;

import java.util.LinkedList;

import com.bokesoft.yigo.meta.base.AbstractMetaObject;
import com.bokesoft.yigo.meta.base.IMetaEnv;
import com.bokesoft.yigo.meta.base.KeyPairMetaObject;
import com.bokesoft.yigo.meta.base.MetaException;

public class MetaArchiveTarget extends KeyPairMetaObject {
	public static final String TAG_NAME="ArchiveTarget";
	
	/** 目标规则组标识*/
	private String key="";
	/** 目标数据库类型*/
	private Integer type = -1;
	/** 当目标数据库类型为NOSQL时，指定的具体数据库类型*/
	private Integer secondType = -1;
	/** 当目标数据库为RMDB时，指定的数据源*/
	private String dsn = "";
	/** 自定义归档实现*/
	private String provider="";
	
	public Integer getType() {
		return type;
	}

	public void setType(Integer type) {
		this.type = type;
	}

	public Integer getSecondType() {
		return secondType;
	}

	public void setSecondType(Integer secondType) {
		this.secondType = secondType;
	}

	public String getDsn() {
		return dsn;
	}

	public void setDsn(String dsn) {
		this.dsn = dsn;
	}

	public String getProvider() {
		return provider;
	}

	public void setProvider(String provider) {
		this.provider = provider;
	}

	public void setKey(String key) {
		this.key = key;
	}

	@Override
	public String getKey() {
		return key;
	}

	@Override
	public void getChildMetaObjects(LinkedList<Object> list) {

	}

	@Override
	public String getTagName() {
		return TAG_NAME;
	}

	@Override
	public AbstractMetaObject createChildMetaObject(IMetaEnv env, Object doc, Object node, String tagName, Object flag,
			int runType) throws MetaException {
		return null;
	}

	@Override
	public AbstractMetaObject clone() {
		MetaArchiveTarget newObj = new MetaArchiveTarget();
		newObj.key = key;
		newObj.type = type;
		newObj.secondType = secondType;
		newObj.dsn = dsn;
		newObj.provider = provider;
		return newObj;
	}

	@Override
	public AbstractMetaObject newInstance() {
		return new MetaArchiveTarget();
	}

}
