package com.bokesoft.yigo.meta.app;

import java.util.LinkedList;

import com.bokesoft.yigo.meta.base.AbstractMetaObject;
import com.bokesoft.yigo.meta.base.IMetaEnv;
import com.bokesoft.yigo.meta.base.MetaException;

/**
 * MetaClientAppStatusInfoItem应用程序状态信息定义，定义信息的标识，显示值，皮肤等
 * @author wangyh
 *
 */
public class MetaClientAppStatusInfoItem extends AbstractMetaObject {
	/** 标识 */
	private String key = "";
	/** 显示值 */
	private String caption = "";
	/** 表达式表示的显示值 */
	private String formulaCaption = "";
	
	public MetaClientAppStatusInfoItem() {
		super();
	}
	
	@Override
	public void getChildMetaObjects(LinkedList<Object> list) {
		// TODO Auto-generated method stub
		
	}

	public static final String TAG_NAME = "StatusInfoItem";
	
	@Override
	public String getTagName() {
		return TAG_NAME;
	}
	
	/**
	 * 设置标识
	 * @param key 标识
	 */
	public void setKey(String key) {
		this.key = key;
	}
	
	/**
	 * 取得标识
	 * @return 标识
	 */
	public String getKey() {
		return this.key;
	}
	
	/**
	 * 设置名称
	 * @param caption 名称
	 */
	public void setCaption(String caption) {
		this.caption = caption;
	}
	
	/**
	 * 取得名称
	 * @return 名称
	 */
	public String getCaption() {
		return this.caption;
	}
	
	/**
	 * 设置表达式名称
	 * @param formulaCaption 表达式
	 */
	public void setFormulaCaption(String formulaCaption) {
		this.formulaCaption = formulaCaption;
	}
	
	/**
	 * 取得表达式名称
	 * @return 表达式名称
	 */
	public String getFormulaCaption() {
		return this.formulaCaption;
	}

	@Override
	public AbstractMetaObject createChildMetaObject(IMetaEnv env, Object doc,
			Object node, String tagName, Object flag, int runType)
			throws MetaException {
		// TODO Auto-generated method stub
		return null;
	}

	@Override
	public AbstractMetaObject clone() {
		MetaClientAppStatusInfoItem newObject = (MetaClientAppStatusInfoItem)newInstance();
		newObject.setKey(key);
		newObject.setCaption(caption);
		newObject.setFormulaCaption(formulaCaption);
		
		return newObject;
	}

	@Override
	public AbstractMetaObject newInstance() {
		return new MetaClientAppStatusInfoItem();
	}

}
