package com.bokesoft.yigo.meta.app;

import java.util.LinkedList;

import com.bokesoft.yigo.meta.base.AbstractMetaObject;
import com.bokesoft.yigo.meta.base.GenericNoKeyCollection;
import com.bokesoft.yigo.meta.base.IMetaEnv;
import com.bokesoft.yigo.meta.base.MetaException;

/**
 * MetaApp定义多应用情况下的应用信息
 * @author wangyh
 *
 */
public class MetaApp extends GenericNoKeyCollection<MetaRefProject> {
	/** 标识 */
	private String key = "";
	/** 名称 */
	private String caption = "";
	/** 描述 */
	private String description = "";
	
	@Override
	public void getChildMetaObjects(LinkedList<Object> list) {
		// TODO Auto-generated method stub
		
	}
	
	public static final String TAG_NAME = "App";

	@Override
	public String getTagName() {
		return TAG_NAME;
	}

	@Override
	public AbstractMetaObject createChildMetaObject(IMetaEnv env, Object doc, Object node, String tagName, Object flag,
			int runType) throws MetaException {
		AbstractMetaObject resultMetaObject = null;
		if ( MetaRefProject.TAG_NAME.equals(tagName) ) {
			MetaRefProject project = new MetaRefProject();
			this.add(project);
			resultMetaObject = project;
		}
		return resultMetaObject;
	}

	@Override
	public AbstractMetaObject clone() {
		MetaApp newObject = (MetaApp)newInstance();
		newObject.setKey(key);
		newObject.setCaption(caption);
		newObject.setDescription(description);
		
		return newObject;
	}
	
	public MetaRefProject getRefProject(String key) {
		MetaRefProject metaRefProject = null;
		for (int i = 0; i < size(); i++) {
			metaRefProject = get(i);
			if (metaRefProject.getKey().equals(key)) {
				return metaRefProject;
			}
		}
		return null;
	}

	@Override
	public AbstractMetaObject newInstance() {
		return new MetaApp();
	}

	/**
	 * 设置标识
	 * @param key 标识
	 */
	public void setKey(String key) {
		this.key = key;
	}
	
	/**
	 * 取得标识
	 * @return 标识
	 */
	public String getKey() {
		return this.key;
	}
	
	/**
	 * 设置名称
	 * @param caption 名称
	 */
	public void setCaption(String caption) {
		this.caption = caption;
	}
	
	/**
	 * 取得名称
	 * @return 名称
	 */
	public String getCaption() {
		return this.caption;
	}
	
	/**
	 * 设置描述
	 * @param description 描述
	 */
	public void setDescription(String description) {
		this.description = description;
	}
	
	/**
	 * 取得描述
	 * @return 描述
	 */
	public String getDescription() {
		return this.description;
	}
}
