package com.bokesoft.yigo.meta.annotation;

import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;

import com.bokesoft.yigo.common.def.OverwriteType;

/**
 * 数据源数注解，用于数据元素属性合并
 * @author zhufw
 *
 */
@Retention(RetentionPolicy.RUNTIME)
@Target(ElementType.FIELD)
public @interface DataElementAttribute {
	
	/** 关联属性名 缺省时标识和原字段相同*/
	String refName() default "";
	
	/** 覆盖方式*/
	int overwriteType() default OverwriteType.ALWAYS;
	
	boolean allowNull() default true;
}
