package com.bokesoft.yes.meta.persist.dom.taskflow;

import org.w3c.dom.Document;
import org.w3c.dom.Element;

import com.bokesoft.yes.meta.persist.dom.BaseDomAction;
import com.bokesoft.yigo.common.dom.DomHelper;
import com.bokesoft.yigo.meta.taskflow.node.MetaSequenceFlow;

public class MetaSequenceFlowAction extends BaseDomAction<MetaSequenceFlow> {

	@Override
	public void load(Document document, Element element, MetaSequenceFlow meta, int runType) {
		meta.setCaption(DomHelper.readAttr(element, MetaConstants.SEQUENCEFLOW_CAPTION, ""));
		meta.setTargetRef(DomHelper.readAttr(element, MetaConstants.SEQUENCEFLOW_TARGETREF, ""));
	}

	@Override
	public void save(Document document, Element element, MetaSequenceFlow meta, int runType) {
		DomHelper.writeAttr(element, MetaConstants.SEQUENCEFLOW_CAPTION, meta.getCaption(), "");
		DomHelper.writeAttr(element, MetaConstants.SEQUENCEFLOW_TARGETREF, meta.getTargetRef(), "");
	}
	
}
