package com.bokesoft.yes.meta.persist.dom.task.action.transition;

import org.w3c.dom.Document;
import org.w3c.dom.Element;

import com.bokesoft.yes.meta.persist.dom.bpm.action.MetaBPMElementAction;
import com.bokesoft.yigo.common.dom.DomHelper;
import com.bokesoft.yigo.meta.bpm.BPMConstants;
import com.bokesoft.yigo.meta.task.transition.MetaTaskTransition;

public abstract class MetaTaskTransitionAction<T extends MetaTaskTransition> extends MetaBPMElementAction<T> {

	@Override
	public void load(Document doc, Element node, T meta, int runType) {
		meta.setTargetNodeKey(DomHelper.readAttr(node, BPMConstants.TRANSITION_TARGETNODEKEY	, ""));
		super.load(doc, node, meta, runType);
	}

	@Override
	public void save(Document doc, Element node, T meta, int runType) {
		DomHelper.writeAttr(node, BPMConstants.TRANSITION_TARGETNODEKEY, meta.getTargetNodeKey(), "");
		super.save(doc, node, meta, runType);
	}

}
