package com.bokesoft.yes.meta.persist.dom.task.action.deploy;

import org.w3c.dom.Document;
import org.w3c.dom.Element;

import com.bokesoft.yes.meta.persist.dom.BaseDomAction;
import com.bokesoft.yes.meta.persist.dom.form.MetaConstants;
import com.bokesoft.yigo.common.dom.DomHelper;
import com.bokesoft.yigo.meta.bpm.BPMConstants;
import com.bokesoft.yigo.meta.task.deploy.MetaTaskProcessDeployInfo;

public class MetaTaskProcessDeployInfoAction extends BaseDomAction<MetaTaskProcessDeployInfo> {

	@Override
	public void load(Document document, Element element, MetaTaskProcessDeployInfo meta, int runType) {
		meta.setKey(DomHelper.readAttr(element, MetaConstants.COMMON_KEY, ""));
		meta.setInitDate(DomHelper.readAttr(element, BPMConstants.COMMON_INIT_DATE, ""));
		meta.setVersion(DomHelper.readInt(element, BPMConstants.COMMON_VERSION, 1));
	}

	@Override
	public void save(Document document, Element element, MetaTaskProcessDeployInfo meta, int runType) {
		DomHelper.writeAttr(element, MetaConstants.COMMON_KEY, meta.getKey(), "");
		DomHelper.writeAttr(element, BPMConstants.COMMON_VERSION, meta.getVersion(), 1);
		DomHelper.writeAttr(element, BPMConstants.COMMON_INIT_DATE, meta.getInitDate(), "");
	}

}
