package com.bokesoft.yes.meta.persist.dom.solution;

import org.w3c.dom.Document;
import org.w3c.dom.Element;

import com.bokesoft.yes.meta.persist.dom.BaseDomAction;
import com.bokesoft.yes.meta.persist.dom.form.MetaConstants;
import com.bokesoft.yigo.common.dom.DomHelper;
import com.bokesoft.yigo.meta.solution.MetaScheduleJob;

public class MetaScheduleJobAction extends BaseDomAction<MetaScheduleJob>{

	@Override
	public void load(Document document, Element element, MetaScheduleJob meta,
			int runType) {
		meta.setName(DomHelper.readAttr(element, MetaConstants.JOB_NAME, ""));
		meta.setGroup(DomHelper.readAttr(element, MetaConstants.JOB_GROUP, ""));
		meta.setClazz(DomHelper.readAttr(element, MetaConstants.JOB_CLASS, ""));
		meta.setDescription(DomHelper.readAttr(element, MetaConstants.JOB_DESCRIPTION, ""));
	}

	@Override
	public void save(Document document, Element element, MetaScheduleJob meta,
			int runType) {
		DomHelper.writeAttr(element, MetaConstants.JOB_NAME, meta.getName(), "");
		DomHelper.writeAttr(element, MetaConstants.JOB_GROUP, meta.getGroup(), "");
		DomHelper.writeAttr(element, MetaConstants.JOB_CLASS, meta.getClazz(), "");
		DomHelper.writeAttr(element, MetaConstants.JOB_DESCRIPTION, meta.getDescription(), "");
	}

}
