package com.bokesoft.yes.meta.persist.dom.solution;

import java.io.InputStream;

import com.bokesoft.yigo.meta.base.IMetaResolver;
import com.bokesoft.yigo.meta.base.IMetaResourceFilter;
import com.bokesoft.yigo.meta.solution.MetaProject;
import com.bokesoft.yigo.meta.strings.MetaStringTable;

public class MetaProjectI18NScanLoad extends BaseMetaScanLoad {
	private MetaStringTable strings = null;
	public MetaProjectI18NScanLoad(MetaStringTable strings, IMetaResolver resolver, MetaProject metaProject, Object context) {
		super(resolver, metaProject, "", context);
		this.strings = strings;
		this.filter = new IMetaResourceFilter() {

			@Override
			public boolean isAccepted(String fileName) {
				return fileName.startsWith("strings-"); // 对i18n下strings-lang.xml文件扫描
			}

		};
	}

	@Override
	public void loadMetaData(Object parent, String parentPath, String filePath, String fileName) throws Exception {
		// strings-lang.xml
		int firstIndex = fileName.indexOf('-');
		int secondIndex = fileName.lastIndexOf('.');
		String lang = fileName.substring(firstIndex + 1, secondIndex);
		InputStream in = resolver.read(filePath, 0);
		strings.load(lang, in);
		
		in.close();
	}

}