package com.bokesoft.yes.meta.persist.dom.solution;

import java.util.Iterator;
import java.util.Map.Entry;

import org.json.JSONObject;

import com.bokesoft.yes.meta.i18n.StringTable;
import com.bokesoft.yes.meta.persist.dom.DomMetaConstants;
import com.bokesoft.yes.meta.persist.dom.form.MetaConstants;
import com.bokesoft.yes.meta.persist.dom.paratable.MetaParaTableLoad;
import com.bokesoft.yigo.common.def.AppRunType;
import com.bokesoft.yigo.common.util.SimpleStringFormat;
import com.bokesoft.yigo.meta.base.IMetaResolver;
import com.bokesoft.yigo.meta.base.MetaException;
import com.bokesoft.yigo.meta.paratable.MetaParaGroup;
import com.bokesoft.yigo.meta.paratable.MetaParaTable;

public class MetaParaTableScanLoad extends BaseMetaScanLoad{

	private MetaParaTable paraTable = null;
	private String solutionKey = "";
	private boolean isExtend = false;

	public MetaParaTableScanLoad(IMetaResolver resolver, MetaParaTable paraTable, String solutionKey, String fileName) {
		super(resolver, null, fileName, null);
		this.isExtend =  DomMetaConstants.PARATABLE_FILE_VEST.equalsIgnoreCase(fileName);
		this.paraTable = paraTable;
		this.solutionKey = solutionKey;
	}

	@Override
	public void loadMetaData(Object parent, String parentPath, String filePath, String fileName) throws Exception {
		JSONObject profileInfo = resolver.readProfile(filePath, 0);
		if (profileInfo != null) {
			String tagName = profileInfo.optString(MetaConstants.COMMON_TAG_NAME);
			if (MetaParaTable.TAG_NAME.equals(tagName)) {
				MetaParaTableLoad load = new MetaParaTableLoad(AppRunType.App);
				load.load(resolver, filePath);
				MetaParaTable currentPT = (MetaParaTable) load.getRootMetaObject();

				Iterator<Entry<String, MetaParaGroup>> itPT = currentPT.entryIterator();
				Entry<String, MetaParaGroup> entry = null;
				String groupKey = "";
				MetaParaGroup metaPG = null;
				while (itPT.hasNext()) {
					entry = itPT.next();
					groupKey = entry.getKey();
					metaPG = entry.getValue();

					MetaParaGroup t = paraTable.get(groupKey);

					// 存在马甲 如果当前也是马甲，key相同 报错
					if (t != null && t.isExtend() && isExtend) {
						throw new MetaException(MetaException.REPEAT_PARA_GROUP_DEFINED, SimpleStringFormat.format(
								StringTable.getString(null, "", StringTable.RepeatParaGroupDefined), groupKey));
					} else if (t != null && !t.isExtend() && !isExtend) {// 不是马甲， 当前也不是马甲 报错
						throw new MetaException(MetaException.REPEAT_PARA_GROUP_DEFINED, SimpleStringFormat.format(
								StringTable.getString(null, "", StringTable.RepeatParaGroupDefined), groupKey));
					} else if (t != null && t.isExtend() && !isExtend) {// 存在马甲， 当前读取的非马甲，合并差异
						t.merge(metaPG);
					} else if (t != null) {
						metaPG.merge(t);
						metaPG.setSolution(this.solutionKey);
						metaPG.setExtend(isExtend);
						this.paraTable.add(metaPG);
					} else {
						metaPG.setSolution(this.solutionKey);
						metaPG.setExtend(isExtend);
						this.paraTable.add(metaPG);
					}

				}
			}
		}
	}

	@Override
	protected void scan(Object parent, String filePath) throws Throwable {
		loadMetaData(parent, "", filePath, filePath);
	}

}
