package com.bokesoft.yes.meta.persist.dom.solution;

import java.io.File;
import java.io.InputStream;
import java.util.Set;

import org.apache.commons.io.FileUtils;

import com.bokesoft.yes.meta.i18n.StringTable;
import com.bokesoft.yes.meta.persist.dom.DomMetaConstants;
import com.bokesoft.yigo.common.util.SimpleStringFormat;
import com.bokesoft.yigo.meta.base.IMetaResolver;
import com.bokesoft.yigo.meta.base.IMetaResourceFilter;
import com.bokesoft.yigo.meta.base.MetaException;
import com.bokesoft.yigo.meta.solution.MetaProject;

public class MetaJarScanLoad extends BaseMetaScanLoad {
	private String pluginsPath = null;
	private Set<String> jarNameSet = null;
	public MetaJarScanLoad(Set<String> jarNameSet, String pluginsPath, IMetaResolver resolver, MetaProject metaProject, Object context) {
		super(resolver, metaProject, DomMetaConstants.ENHANCE_FOLD, context);
		this.pluginsPath = pluginsPath;
		fileFilter = ".jar";
		this.jarNameSet = jarNameSet;
		setFilter(new IMetaResourceFilter() {

			@Override
			public boolean isAccepted(String fileName) {
				return fileName.endsWith(".jar");
			}
		});
	}

	@Override
	public void loadMetaData(Object parent, String parentPath, String filePath, String fileName) throws Exception {
		// 直接将jar包copy到指定目录
		try (InputStream is = resolver.read(filePath, -1)) {
			if (is != null) {
				if (jarNameSet.contains(fileName)) {
					throw new MetaException(MetaException.REPEAT_JAR_FILE_DEFINED, SimpleStringFormat
							.format(StringTable.getString(null, "", StringTable.RepeatJarFileDefined), fileName));
				} else {
					jarNameSet.add(fileName);
				}
				File target = new File(pluginsPath, fileName);
				FileUtils.copyInputStreamToFile(is, target);
			}
		}
	}

}
