package com.bokesoft.yes.meta.persist.dom.solution;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

import org.json.JSONObject;

import com.bokesoft.yes.meta.i18n.StringTable;
import com.bokesoft.yes.meta.persist.dom.DomMetaConstants;
import com.bokesoft.yes.meta.persist.dom.datamap.MetaMapLoad;
import com.bokesoft.yes.meta.persist.dom.form.MetaConstants;
import com.bokesoft.yigo.common.def.AppRunType;
import com.bokesoft.yigo.common.util.SimpleStringFormat;
import com.bokesoft.yigo.meta.base.IMetaResolver;
import com.bokesoft.yigo.meta.base.MetaException;
import com.bokesoft.yigo.meta.datamap.MetaDataMapList;
import com.bokesoft.yigo.meta.datamap.MetaDataMapProfile;
import com.bokesoft.yigo.meta.datamap.MetaMap;
import com.bokesoft.yigo.meta.solution.MetaProject;

public class MetaDataMapScanLoad extends BaseMetaScanLoad {
	private int runType = AppRunType.App;
	private MetaDataMapList dataMapList;
	private Map<String, MetaDataMapProfile> map = null;
	
	public MetaDataMapScanLoad(MetaDataMapList dataMapList, IMetaResolver resolver, MetaProject metaProject, Object context, int runType) {
		super(resolver, metaProject, DomMetaConstants.DATAMAP_FOLD, context);
		this.dataMapList = dataMapList;
		this.runType = runType;
		this.map = new ConcurrentHashMap<>();
	}
	
	protected void doFind(Object parent, String parentPath, String filePath, String fileName, MetaDataMapProfile profile) {
		
	}
	
	protected void postLoad() throws Throwable {
		super.postLoad();
		merge();
	}
	
	@Override
	public void loadMetaData(Object parent, String parentPath, String filePath, String fileName) throws Exception {
		JSONObject profileInfo = resolver.readProfile(filePath, 0);
		if (profileInfo != null) {
			String tagName = profileInfo.optString(MetaConstants.COMMON_TAG_NAME);
			if (MetaMap.TAG_NAME.equals(tagName)) {
				MetaMapLoad load = new MetaMapLoad(AppRunType.App);
				load.load(resolver, filePath);
				MetaMap dataMap = (MetaMap) load.getRootMetaObject();
				dataMap.setProject(metaProject);
				if (dataMap != null) {
					MetaDataMapProfile profile = new MetaDataMapProfile();
					profile.setKey(dataMap.getKey());
					profile.setCaption(dataMap.getCaption());
					profile.setDescription(dataMap.getDescription());
					profile.setSrcDataObjectKey(dataMap.getSrcDataObjectKey());
					profile.setTgtDataObjectKey(dataMap.getTgtDataObjectKey());
					profile.setDataMap(dataMap);
					profile.setProject(metaProject);
					profile.setResource(filePath);
					if ( map.containsKey(profile.getKey())) {
						throw new MetaException(MetaException.REPEAT_DATA_MAP_DEFINED,
								SimpleStringFormat.format(
										StringTable.getString(null, "", StringTable.RepeatDataMapDefined),
										metaProject.getKey(), profile.getKey()));
					}
					doFind(parent, parentPath, filePath, fileName, profile);
					map.put(profile.getKey(), profile);
				}
			}
		}
	}

	public int getRunType() {
		return runType;
	}

	private void merge() {
		if(map.isEmpty()) {
			return;
		}
		try {
			map.values().forEach(profile -> {
				this.dataMapList.add(profile);
			});
		}finally {
			map.clear();
		}
	}
	
	public MetaDataMapList getMetaDataMapList() {
		merge();
		return this.dataMapList;
	}
}
