package com.bokesoft.yes.meta.persist.dom.setting;

import com.bokesoft.yes.meta.persist.dom.MetaActionMap;
import com.bokesoft.yes.meta.persist.dom.bpm.action.collection.MetaAdministratorCollectionAction;
import com.bokesoft.yes.meta.persist.dom.bpm.action.collection.MetaSourceParaCollectionAction;
import com.bokesoft.yes.meta.persist.dom.bpm.action.collection.item.MetaDictAdministratorAction;
import com.bokesoft.yes.meta.persist.dom.bpm.action.collection.item.MetaDictionaryAction;
import com.bokesoft.yes.meta.persist.dom.bpm.action.collection.item.MetaExternalLinkAction;
import com.bokesoft.yes.meta.persist.dom.bpm.action.collection.item.MetaMidFormulaAction;
import com.bokesoft.yes.meta.persist.dom.bpm.action.collection.item.MetaMidFormulaAdministratorAction;
import com.bokesoft.yes.meta.persist.dom.bpm.action.collection.item.MetaQueryAction;
import com.bokesoft.yes.meta.persist.dom.bpm.action.collection.item.MetaQueryAdministratorAction;
import com.bokesoft.yes.meta.persist.dom.bpm.action.collection.item.MetaRelationAction;
import com.bokesoft.yes.meta.persist.dom.bpm.action.collection.item.MetaSourceParaAction;
import com.bokesoft.yes.meta.persist.dom.common.MetaBaseScriptAction;
import com.bokesoft.yes.meta.persist.dom.form.MetaRightsProxyAction;
import com.bokesoft.yes.meta.persist.dom.form.MetaRightsProxyCollectionAction;
import com.bokesoft.yes.meta.persist.dom.form.component.control.properties.MetaParaAction;
import com.bokesoft.yes.meta.persist.dom.form.component.control.properties.MetaParasAction;
import com.bokesoft.yigo.meta.base.AbstractMetaObject;
import com.bokesoft.yigo.meta.base.IMetaAction;
import com.bokesoft.yigo.meta.bpm.BPMConstants;
import com.bokesoft.yigo.meta.bpm.process.attribute.participator.MetaDictionary;
import com.bokesoft.yigo.meta.bpm.process.attribute.participator.MetaExternalLink;
import com.bokesoft.yigo.meta.bpm.process.attribute.participator.MetaMidFormula;
import com.bokesoft.yigo.meta.bpm.process.attribute.participator.MetaQuery;
import com.bokesoft.yigo.meta.bpm.process.attribute.participator.MetaRelation;
import com.bokesoft.yigo.meta.bpm.process.attribute.participator.MetaSourcePara;
import com.bokesoft.yigo.meta.bpm.process.attribute.participator.MetaSourceParaCollection;
import com.bokesoft.yigo.meta.bpm.process.attribute.processadministrator.MetaAdministratorCollection;
import com.bokesoft.yigo.meta.bpm.process.attribute.processadministrator.MetaDictAdministrator;
import com.bokesoft.yigo.meta.bpm.process.attribute.processadministrator.MetaMidFormulaAdministrator;
import com.bokesoft.yigo.meta.bpm.process.attribute.processadministrator.MetaQueryAdministrator;
import com.bokesoft.yigo.meta.common.MetaBaseScript;
import com.bokesoft.yigo.meta.common.MetaPara;
import com.bokesoft.yigo.meta.common.MetaParas;
import com.bokesoft.yigo.meta.form.MetaRightsProxy;
import com.bokesoft.yigo.meta.form.MetaRightsProxyCollection;
import com.bokesoft.yigo.meta.setting.MetaAttachmentProvider;
import com.bokesoft.yigo.meta.setting.MetaAttachmentService;
import com.bokesoft.yigo.meta.setting.MetaAuthService;
import com.bokesoft.yigo.meta.setting.MetaAuthServices;
import com.bokesoft.yigo.meta.setting.MetaBPMMColumn;
import com.bokesoft.yigo.meta.setting.MetaBPMMTable;
import com.bokesoft.yigo.meta.setting.MetaBPMSetting;
import com.bokesoft.yigo.meta.setting.MetaCluster;
import com.bokesoft.yigo.meta.setting.MetaDTS;
import com.bokesoft.yigo.meta.setting.MetaDTSProvider;
import com.bokesoft.yigo.meta.setting.MetaEntrySetting;
import com.bokesoft.yigo.meta.setting.MetaFormSetting;
import com.bokesoft.yigo.meta.setting.MetaIOProvider;
import com.bokesoft.yigo.meta.setting.MetaIOService;
import com.bokesoft.yigo.meta.setting.MetaLoginSetting;
import com.bokesoft.yigo.meta.setting.MetaMigrationSetting;
import com.bokesoft.yigo.meta.setting.MetaSession;
import com.bokesoft.yigo.meta.setting.MetaSessionPara;
import com.bokesoft.yigo.meta.setting.MetaSetting;
import com.bokesoft.yigo.meta.setting.MetaSysColumn;
import com.bokesoft.yigo.meta.setting.MetaSysTopic;
import com.bokesoft.yigo.meta.setting.MetaSystemTopics;

public class MetaSettingActionMap extends MetaActionMap {
	private Object simpleSettingAction = new MetaSimpleSettingAction();
	@Override
	protected Object[][] getActionLookupTable() {
		return new Object[][] {
				{ MetaSetting.TAG_NAME, new MetaSettingAction() },
				//attachment
				{ MetaAttachmentService.TAG_NAME, new MetaAttachmentServiceAction() },
				{ MetaAttachmentProvider.TAG_NAME, new MetaAttachmentProviderAction() },
				//datatransfer
				{ MetaDTS.TAG_NAME, new MetaDTSAction() },
				{ MetaDTSProvider.TAG_NAME, new MetaDTSProviderAction() },
				//IOService
				{ MetaIOService.TAG_NAME, new MetaIOServiceAction() },
				{ MetaIOProvider.TAG_NAME, new MetaIOProviderAction() },
				//Paras
				{ MetaParas.TAG_NAME, new MetaParasAction() },
				{ MetaPara.TAG_NAME, new MetaParaAction() },
				
				// 权限代理
				{ MetaRightsProxyCollection.TAG_NAME, new MetaRightsProxyCollectionAction() },
				{ MetaRightsProxy.TAG_NAME, new MetaRightsProxyAction() },
				
				{ MetaSession.TAG_NAME, new MetaSessionAction() },
				{ MetaSessionPara.TAG_NAME, new MetaSessionParaAction() },
				
				{ BPMConstants.DEFAULT_BATCH_STATE_ACTION, new MetaBaseScriptAction<MetaBaseScript>()},
				{ BPMConstants.DEFAULT_STATE_ACTION, new MetaBaseScriptAction<MetaBaseScript>()},
				{ BPMConstants.DEFAULT_AUDIT_ACTION, new MetaBaseScriptAction<MetaBaseScript>()},
				{ BPMConstants.DEFAULT_TASK_ACTION, new MetaBaseScriptAction<MetaBaseScript>()},
				{ BPMConstants.DEFAULT_COUNTERSIGN_ACTION, new MetaBaseScriptAction<MetaBaseScript>()},
				{ BPMConstants.WORKITEM_CREATE_TRIGGER_ACTION, new MetaBaseScriptAction<MetaBaseScript>()},
				
				{ MetaAdministratorCollection.TAG_NAME, new MetaAdministratorCollectionAction()},
				{ MetaDictAdministrator.TAG_NAME, new MetaDictAdministratorAction()},
				{ MetaMidFormulaAdministrator.TAG_NAME, new MetaMidFormulaAdministratorAction()},
				{ MetaQueryAdministrator.TAG_NAME, new MetaQueryAdministratorAction()},
				{ MetaCluster.TAG_NAME, new MetaClusterAction() },
				{ MetaEntrySetting.TAG_NAME, new MetaEntrySettingAction() },
				{ MetaBPMSetting.TAG_NAME, new MetaBPMSettingAction() },
				{ MetaLoginSetting.TAG_NAME, new MetaLoginSettingAction() },
				{ MetaFormSetting.TAG_NAME, new MetaFormSettingAction() },
				{ MetaMigrationSetting.TAG_NAME, new MetaMigrationSettingAction() },
				
				{ MetaAuthService.TAG_NAME, new MetaAuthServiceAction() },
				{ MetaAuthServices.TAG_NAME, new MetaAuthServicesAction() },
				{ MetaBPMMTable.TAG_NAME, new MetaBPMMTableAction() },
				{ MetaSourceParaCollection.TAG_NAME, new MetaSourceParaCollectionAction()},
				{ MetaSourcePara.TAG_NAME, new MetaSourceParaAction()},
				{ MetaBPMMColumn.TAG_NAME, new MetaBPMMColumnAction() },
				{ MetaSystemTopics.TAG_NAME, new MetaSystemTopicsAction()},
				{ MetaSysTopic.TAG_NAME, new MetaSysTopicAction()},
				{ MetaSysColumn.TAG_NAME, new MetaSysColumnAction()}
		};
	}

	/** 设置事件处理的单体实例 */
	private static MetaSettingActionMap instance = null;
	
	/**
	 * 取得设置事件处理的单体实例
	 * @return 实例对象
	 */
	public static MetaSettingActionMap getInsance() {
		if ( instance == null ) {
			instance = new MetaSettingActionMap();
		}
		return instance;
	}

	@Override
	protected Object[][] getHostActionLookupTable() {
		return null;
	}
	
	@SuppressWarnings("unchecked")
	@Override
	public IMetaAction<AbstractMetaObject> getAction(String parentTag, String tag) {
		IMetaAction<AbstractMetaObject> action = super.getAction(parentTag, tag);
		if ( action == null ) {
			action = (IMetaAction<AbstractMetaObject>)simpleSettingAction;
		}
		return action;
	}
}
