package com.bokesoft.yes.meta.persist.dom.setting;

import org.w3c.dom.Document;
import org.w3c.dom.Element;

import com.bokesoft.yes.meta.persist.dom.BaseDomAction;
import com.bokesoft.yes.meta.persist.dom.form.MetaConstants;
import com.bokesoft.yigo.common.dom.DomHelper;
import com.bokesoft.yigo.meta.setting.MetaSessionPara;

public class MetaSessionParaAction extends BaseDomAction<MetaSessionPara> {

	@Override
	public void load(Document document, Element element, MetaSessionPara meta, int runType) {
		meta.setParaKey(DomHelper.readAttr(element, MetaConstants.SESSION_PARA_KEY, ""));
		meta.setParaTitle(DomHelper.readAttr(element, MetaConstants.SESSION_PARA_TITLE, ""));
		meta.setAsCluster(DomHelper.readAttr(element, MetaConstants.SESSION_PARA_ASCLUSTER_, false));
		meta.setProvider(DomHelper.readAttr(element, MetaConstants.SESSION_PARA_PROVIDER, ""));
	}

	@Override
	public void save(Document document, Element element, MetaSessionPara meta, int runType) {
		DomHelper.writeAttr(element, MetaConstants.SESSION_PARA_KEY, meta.getParaKey(), "");
		DomHelper.writeAttr(element, MetaConstants.SESSION_PARA_TITLE, meta.getParaTitle(), "");
		DomHelper.writeAttr(element, MetaConstants.SESSION_PARA_ASCLUSTER_, meta.isAsCluster(), false);
		DomHelper.writeAttr(element, MetaConstants.SESSION_PARA_PROVIDER, meta.getProvider(), "");
	}

}
