package com.bokesoft.yes.meta.persist.dom.setting;

import org.w3c.dom.Document;
import org.w3c.dom.Element;

import com.bokesoft.yes.meta.persist.dom.BaseDomAction;
import com.bokesoft.yigo.common.dom.DomHelper;
import com.bokesoft.yigo.meta.bpm.BPMConstants;
import com.bokesoft.yigo.meta.setting.MetaBPMSetting;

public class MetaBPMSettingAction extends BaseDomAction<MetaBPMSetting> {

	@Override
	public void load(Document document, Element node, MetaBPMSetting meta, int runType) {
		meta.setQueryRetreatWorkitem(DomHelper.readAttr(node, BPMConstants.QUERY_RETREAT_WORKITEM, true));
		meta.setRetreatCaption(DomHelper.readAttr(node, BPMConstants.RETREAT_CAPTION, ""));
		meta.setChooseRollback(DomHelper.readAttr(node, BPMConstants.CHOOSE_ROLLBACK, false));
		meta.setQueryActiveWorkitem(DomHelper.readAttr(node, BPMConstants.QUERY_ACTIVE_WORKITEM, false));
		meta.setQueryActiveStateWorkitem(DomHelper.readAttr(node, BPMConstants.QUERY_ACTIVE_STATE_WORKITEM, true));
		meta.setQueryTransitTo(DomHelper.readAttr(node, BPMConstants.QUERY_TRANSIT_TO, false));
		meta.setBPMTemplatePath(DomHelper.readAttr(node, BPMConstants.BPM_TEMPLATE_PATH, ""));
		meta.setBPMGraphInfoPath(DomHelper.readAttr(node, BPMConstants.BPM_GRAPHINFO_PATH, ""));
		meta.setBPMNodeAction(DomHelper.readAttr(node, BPMConstants.BPM_NODE_ACTION, ""));
		meta.setDelegateCheck(DomHelper.readAttr(node, BPMConstants.BPM_DELEGATE_CHECK, ""));
		meta.setRecalculateActiveWorkitem(DomHelper.readAttr(node, BPMConstants.RECALCULATE_ACTIVE_WORKITEM, false));
		meta.setAddDelegateLog(DomHelper.readAttr(node, BPMConstants.ADD_DELEGATE_LOG, false));
		meta.setCreateLog4BeginNode(DomHelper.readAttr(node, BPMConstants.CREATE_LOG_4_BEGIN_NODE, false));
		meta.setCreateLog4EndNode(DomHelper.readBool(node, BPMConstants.CREATE_LOG_4_END_NODE, false));
		meta.setTemplateKey(DomHelper.readAttr(node, BPMConstants.NODE_TEMPLATEKEY, ""));
		meta.setWorkFlowHookPath(DomHelper.readAttr(node, BPMConstants.BPM_WORKFLOWHOOK_PATH, ""));
		meta.setRecordFormRights(DomHelper.readAttr(node, BPMConstants.RECORD_FORMRIGHTS, false));
		meta.setIgnoreFormState(new Boolean(DomHelper.readAttr(node, BPMConstants.IGNORE_FORM_STATE, false)));
		meta.setUseDefaultRetreateDelegateTimer(DomHelper.readAttr(node, BPMConstants.USE_DEFAULT_RETREAT_DELEGATE_TIMER, true));
		meta.setUseDefaultExecTimeoutItemTimer(DomHelper.readAttr(node, BPMConstants.USE_DEFAULT_EXEC_TIMEOUT_ITEM_TIMER, true));
		meta.setRightsProvider(DomHelper.readAttr(node, BPMConstants.RIGHTS_PROVIDER, ""));
		meta.setSysTopic(DomHelper.readAttr(node, BPMConstants.SYS_TOPIC, ""));
		meta.setCustomExternalResourceModel(DomHelper.readAttr(node, BPMConstants.CUSTOM_EXTERNAL_RESOURCE_MODEL, ""));
		meta.setDefaultExtendProcess(DomHelper.readAttr(node, BPMConstants.DEFAULT_EXTEND_PROCESS, ""));
		meta.setUseDefaultExtendProcess(DomHelper.readAttr(node, BPMConstants.IS_USE_DEFAULT_EXTEND_PROCESS, false));
	}

	@Override
	public void save(Document document, Element node, MetaBPMSetting meta, int runType) {
		DomHelper.writeAttr(node, BPMConstants.QUERY_RETREAT_WORKITEM, meta.getQueryRetreatWorkitem(), true);
		DomHelper.writeAttr(node, BPMConstants.RETREAT_CAPTION, meta.getRetreatCaption(), "");
		DomHelper.writeAttr(node, BPMConstants.CHOOSE_ROLLBACK, meta.isChooseRollback(), false);
		DomHelper.writeAttr(node, BPMConstants.QUERY_ACTIVE_WORKITEM, meta.getQueryActiveWorkitem(), false);
		DomHelper.writeAttr(node, BPMConstants.QUERY_ACTIVE_STATE_WORKITEM, meta.getQueryActiveStateWorkitem(), true);
		DomHelper.writeAttr(node, BPMConstants.QUERY_TRANSIT_TO, meta.getQueryTransitTo(), false);
		DomHelper.writeAttr(node, BPMConstants.BPM_TEMPLATE_PATH, meta.getBPMTemplatePath(), "");
		DomHelper.writeAttr(node, BPMConstants.BPM_GRAPHINFO_PATH, meta.getBPMGraphInfoPath(), "");
		DomHelper.writeAttr(node, BPMConstants.BPM_NODE_ACTION, meta.getBPMNodeAction(), "");
		DomHelper.writeAttr(node, BPMConstants.BPM_DELEGATE_CHECK, meta.getDelegateCheck(), "");
		DomHelper.writeAttr(node, BPMConstants.RECALCULATE_ACTIVE_WORKITEM, meta.isRecalculateActiveWorkitem(), false);
		DomHelper.writeAttr(node, BPMConstants.ADD_DELEGATE_LOG, meta.isAddDelegateLog(), false);
		DomHelper.writeAttr(node, BPMConstants.CREATE_LOG_4_BEGIN_NODE, meta.getCreateLog4BeginNode(), false);
		DomHelper.writeAttr(node, BPMConstants.CREATE_LOG_4_END_NODE, meta.getCreateLog4EndNode(), false);
		DomHelper.writeAttr(node, BPMConstants.NODE_TEMPLATEKEY, meta.getTemplateKey(), "");
		DomHelper.writeAttr(node, BPMConstants.BPM_WORKFLOWHOOK_PATH, meta.getWorkFlowHookPath(), "");
		DomHelper.writeAttr(node, BPMConstants.RECORD_FORMRIGHTS, meta.getRecordFormRights(), false);
		DomHelper.writeAttr(node, BPMConstants.IGNORE_FORM_STATE, meta.getIgnoreFormState(), false);
		DomHelper.writeAttr(node, BPMConstants.USE_DEFAULT_RETREAT_DELEGATE_TIMER, meta.isUseDefaultRetreateDelegateTimer(), true);
		DomHelper.writeAttr(node, BPMConstants.USE_DEFAULT_EXEC_TIMEOUT_ITEM_TIMER, meta.isUseDefaultExecTimeoutItemTimer(), true);
		DomHelper.writeAttr(node, BPMConstants.RIGHTS_PROVIDER, meta.getRightsProvider(), "");
		DomHelper.writeAttr(node, BPMConstants.SYS_TOPIC, meta.getSysTopic(), "");
		DomHelper.writeAttr(node, BPMConstants.CUSTOM_EXTERNAL_RESOURCE_MODEL, meta.getCustomExternalResourceModel(), "");
		DomHelper.writeAttr(node, BPMConstants.DEFAULT_EXTEND_PROCESS, meta.getDefaultExtendProcess(), "");
		DomHelper.writeAttr(node, BPMConstants.IS_USE_DEFAULT_EXTEND_PROCESS, meta.isUseDefaultExtendProcess(), false);
	}
}
