package com.bokesoft.yes.meta.persist.dom.report;

import org.w3c.dom.Document;
import org.w3c.dom.Element;

import com.bokesoft.yes.meta.persist.dom.BaseDomAction;
import com.bokesoft.yigo.common.def.ImageScaleType;
import com.bokesoft.yigo.common.dom.DomHelper;
import com.bokesoft.yigo.meta.report.MetaReportConstants;
import com.bokesoft.yigo.meta.report.MetaReportImageStyle;

public class MetaReportImageStyleAction  extends BaseDomAction<MetaReportImageStyle> {

	@Override
	public void load(Document document, Element element, MetaReportImageStyle meta, int runType) {
		meta.setImageScaleType(ImageScaleType.parse(DomHelper.readAttr(element, MetaReportConstants.CELL_IMAGE_SCALE_TYPE, ImageScaleType.STR_FIT_XY)));
	}

	@Override
	public void save(Document document, Element element, MetaReportImageStyle meta, int runType) {
		DomHelper.writeAttr(element, MetaReportConstants.CELL_IMAGE_SCALE_TYPE, ImageScaleType.toString(meta.getImageScaleType()), ImageScaleType.STR_FIT_XY);
	}

}
