package com.bokesoft.yes.meta.persist.dom.report;

import org.w3c.dom.Document;
import org.w3c.dom.Element;

import com.bokesoft.yes.meta.persist.dom.BaseDomAction;
import com.bokesoft.yigo.common.dom.DomHelper;
import com.bokesoft.yigo.meta.report.MetaReportConstants;
import com.bokesoft.yigo.meta.report.MetaReportFormat;
import com.bokesoft.yigo.meta.report.ReportFormatDataType;

public class MetaReportFormatAction extends BaseDomAction<MetaReportFormat> {

	@Override
	public void load(Document document, Element element, MetaReportFormat meta, int runType) {
		meta.setDataType(ReportFormatDataType.parse(DomHelper.readAttr(element, MetaReportConstants.FORMAT_DATATYPE, ReportFormatDataType.STR_Text)));
		meta.setTransformer(DomHelper.readAttr(element, MetaReportConstants.FORMAT_TRANSFORMER, ""));
		meta.setFormatString(DomHelper.readAttr(element, MetaReportConstants.FORMAT_FORMATSTRING, ""));
		meta.setItemKey(DomHelper.readAttr(element, MetaReportConstants.FORMAT_ITEMKEY, ""));
		meta.setFieldKeys(DomHelper.readAttr(element, MetaReportConstants.FORMAT_FIELDKEYS, ""));
	}

	@Override
	public void save(Document document, Element element, MetaReportFormat meta, int runType) {
		DomHelper.writeAttr(element, MetaReportConstants.FORMAT_DATATYPE, ReportFormatDataType.toString(meta.getDataType()), ReportFormatDataType.STR_Text);
		DomHelper.writeAttr(element, MetaReportConstants.FORMAT_TRANSFORMER, meta.getTransformer(), "");
		DomHelper.writeAttr(element, MetaReportConstants.FORMAT_FORMATSTRING, meta.getFormatString(), "");
		DomHelper.writeAttr(element, MetaReportConstants.FORMAT_ITEMKEY, meta.getItemKey(), "");
		DomHelper.writeAttr(element, MetaReportConstants.FORMAT_FIELDKEYS, meta.getFieldKeys(), "");
	}

}
