package com.bokesoft.yes.meta.persist.dom.report;

import org.w3c.dom.Document;
import org.w3c.dom.Element;

import com.bokesoft.yes.meta.persist.dom.BaseDomAction;
import com.bokesoft.yigo.common.dom.DomHelper;
import com.bokesoft.yigo.meta.report.MetaReportBorder;
import com.bokesoft.yigo.meta.report.MetaReportConstants;
import com.bokesoft.yigo.meta.report.ReportBorderStyle;

public class MetaReportBorderAction extends BaseDomAction<MetaReportBorder> {
	private static final String DEFAULT_COLOR = "";
	@Override
	public void load(Document document, Element element, MetaReportBorder meta, int runType) {
		meta.setLeftStyle(DomHelper.readAttr(element, MetaReportConstants.BORDER_LEFTSTYLE, ReportBorderStyle.None));
		meta.setLeftColor(DomHelper.readAttr(element, MetaReportConstants.BORDER_LEFTCOLOR, DEFAULT_COLOR));
		meta.setTopStyle(DomHelper.readAttr(element, MetaReportConstants.BORDER_TOPSTYLE, ReportBorderStyle.None));
		meta.setTopColor(DomHelper.readAttr(element, MetaReportConstants.BORDER_TOPCOLOR, DEFAULT_COLOR));
		meta.setRightStyle(DomHelper.readAttr(element, MetaReportConstants.BORDER_RIGHTSTYLE, ReportBorderStyle.None));
		meta.setRightColor(DomHelper.readAttr(element, MetaReportConstants.BORDER_RIGHTCOLOR, DEFAULT_COLOR));
		meta.setBottomStyle(DomHelper.readAttr(element, MetaReportConstants.BORDER_BOTTOMSTYLE, ReportBorderStyle.None));
		meta.setBottomColor(DomHelper.readAttr(element, MetaReportConstants.BORDER_BOTTOMCOLOR, DEFAULT_COLOR));
	}

	@Override
	public void save(Document document, Element element, MetaReportBorder meta, int runType) {
		DomHelper.writeAttr(element, MetaReportConstants.BORDER_LEFTSTYLE, meta.getLeftStyle(), ReportBorderStyle.None);
		if ( meta.getLeftStyle() == ReportBorderStyle.None ) {
			DomHelper.removeAttr(element, MetaReportConstants.BORDER_LEFTCOLOR);
		} else {
			DomHelper.writeAttr(element, MetaReportConstants.BORDER_LEFTCOLOR, meta.getLeftColor(), DEFAULT_COLOR);
		}
		DomHelper.writeAttr(element, MetaReportConstants.BORDER_TOPSTYLE, meta.getTopStyle(), ReportBorderStyle.None);
		if ( meta.getTopStyle() == ReportBorderStyle.None ) {
			DomHelper.removeAttr(element, MetaReportConstants.BORDER_TOPCOLOR);
		} else {
			DomHelper.writeAttr(element, MetaReportConstants.BORDER_TOPCOLOR, meta.getTopColor(), DEFAULT_COLOR);
		}
		DomHelper.writeAttr(element, MetaReportConstants.BORDER_RIGHTSTYLE, meta.getRightStyle(), ReportBorderStyle.None);
		if ( meta.getRightStyle() == ReportBorderStyle.None ) {
			DomHelper.removeAttr(element, MetaReportConstants.BORDER_RIGHTCOLOR);
		} else {
			DomHelper.writeAttr(element, MetaReportConstants.BORDER_RIGHTCOLOR, meta.getRightColor(), DEFAULT_COLOR);
		}
		DomHelper.writeAttr(element, MetaReportConstants.BORDER_BOTTOMSTYLE, meta.getBottomStyle(), ReportBorderStyle.None);
		if ( meta.getBottomStyle() == ReportBorderStyle.None ) {
			DomHelper.removeAttr(element, MetaReportConstants.BORDER_BOTTOMCOLOR);
		} else {
			DomHelper.writeAttr(element, MetaReportConstants.BORDER_BOTTOMCOLOR, meta.getBottomColor(), DEFAULT_COLOR);
		}
	}

}
