package com.bokesoft.yes.meta.persist.dom.relation.relationset;

import org.w3c.dom.Document;
import org.w3c.dom.Element;

import com.bokesoft.yes.meta.persist.dom.BaseDomAction;
import com.bokesoft.yes.meta.persist.dom.form.MetaConstants;
import com.bokesoft.yigo.common.def.PathTargetType;
import com.bokesoft.yigo.common.dom.DomHelper;
import com.bokesoft.yigo.meta.path.relation.MetaRelationPart;
import com.bokesoft.yigo.meta.relation.MetaRelationConstants;

public class MetaRelationPartAction extends BaseDomAction<MetaRelationPart> {

	@Override
	public void load(Document document, Element element, MetaRelationPart meta, int runType) {
		meta.setKey(DomHelper.readAttr(element, MetaConstants.COMMON_KEY, ""));
		meta.setCaption(DomHelper.readAttr(element, MetaConstants.COMMON_CAPTION, ""));
		meta.setIDseed(Integer.parseInt(DomHelper.readAttr(element, MetaRelationConstants.RELATION_IDSEED, "-1")));
	}

	@Override
	public void save(Document document, Element element, MetaRelationPart meta, int runType) {
		DomHelper.writeAttr(element, MetaConstants.COMMON_KEY, meta.getKey(), "");
		DomHelper.writeAttr(element, MetaConstants.COMMON_CAPTION, meta.getCaption(), "");
		DomHelper.writeAttr(element, MetaRelationConstants.RELATION_IDSEED, Integer.toString(meta.getIDseed()), "-1");
	}

}
