package com.bokesoft.yes.meta.persist.dom.relation.path;

import org.w3c.dom.Document;
import org.w3c.dom.Element;

import com.bokesoft.yes.meta.persist.dom.BaseDomAction;
import com.bokesoft.yes.meta.persist.dom.form.MetaConstants;
import com.bokesoft.yigo.common.def.PathTargetType;
import com.bokesoft.yigo.common.dom.DomHelper;
import com.bokesoft.yigo.meta.path.MetaRelationPath;
import com.bokesoft.yigo.meta.relation.MetaRelationConstants;

public class MetaRelationPathAction extends BaseDomAction<MetaRelationPath> {

	@Override
	public void load(Document document, Element element, MetaRelationPath meta, int runType) {
		// TODO Auto-generated method stub
		meta.setKey(DomHelper.readAttr(element, MetaConstants.COMMON_KEY, ""));
		meta.setCaption(DomHelper.readAttr(element, MetaConstants.COMMON_CAPTION, ""));
		meta.setIDseed(Integer.parseInt(DomHelper.readAttr(element, MetaRelationConstants.RELATION_IDSEED, "-1")));
		meta.setFormkey(DomHelper.readAttr(element, MetaRelationConstants.RELATION_FORMKEY, ""));
		meta.setTargetkey(DomHelper.readAttr(element, MetaRelationConstants.RELATION_TARGETKEY, ""));
		meta.setType(PathTargetType.parse(DomHelper.readAttr(element, MetaConstants.COMMON_TYPE, "")));
		meta.setX(Integer.parseInt(DomHelper.readAttr(element, MetaRelationConstants.RELATION_X, "-1")));
		meta.setY(Integer.parseInt(DomHelper.readAttr(element, MetaRelationConstants.RELATION_Y, "-1")));
	}

	@Override
	public void save(Document document, Element element, MetaRelationPath meta, int runType) {
		// TODO Auto-generated method stub
		DomHelper.writeAttr(element, MetaConstants.COMMON_KEY, meta.getKey(), "");
		DomHelper.writeAttr(element, MetaConstants.COMMON_CAPTION, meta.getCaption(), "");
		DomHelper.writeAttr(element, MetaRelationConstants.RELATION_IDSEED, Integer.toString(meta.getIDseed()), "-1");
		DomHelper.writeAttr(element, MetaRelationConstants.RELATION_FORMKEY, meta.getFormkey(), "");
		DomHelper.writeAttr(element, MetaRelationConstants.RELATION_TARGETKEY, meta.getTargetkey(), "");
		DomHelper.writeAttr(element, MetaConstants.COMMON_TYPE, PathTargetType.toString(meta.getType()), "");
		DomHelper.writeAttr(element, MetaRelationConstants.RELATION_X, Integer.toString(meta.getX()), "-1");
		DomHelper.writeAttr(element, MetaRelationConstants.RELATION_Y, Integer.toString(meta.getY()), "-1");
	}

}
