package com.bokesoft.yes.meta.persist.dom.relation.path;

import org.w3c.dom.Document;
import org.w3c.dom.Element;

import com.bokesoft.yes.meta.persist.dom.BaseDomAction;
import com.bokesoft.yigo.common.dom.DomHelper;
import com.bokesoft.yigo.meta.path.line.MetaRelationCheckData;
import com.bokesoft.yigo.meta.relation.MetaRelationConstants;

public class MetaRelationCheckDataAction extends BaseDomAction<MetaRelationCheckData> {

	@Override
	public void load(Document document, Element element, MetaRelationCheckData meta, int runType) {
		meta.setTablekey(DomHelper.readAttr(element, MetaRelationConstants.RELATION_TABLEKEY, ""));
		meta.setColumnkey(DomHelper.readAttr(element, MetaRelationConstants.RELATION_COLUMNKEY, ""));
		meta.setErrorInfo(DomHelper.readAttr(element, MetaRelationConstants.RELATION_ERROR_INFO, ""));
		meta.setOperation(DomHelper.readAttr(element, MetaRelationConstants.RELATION_OPERATION, ""));
	}

	@Override
	public void save(Document document, Element element, MetaRelationCheckData meta, int runType) {
		DomHelper.writeAttr(element, MetaRelationConstants.RELATION_TABLEKEY, meta.getTablekey(), "");
		DomHelper.writeAttr(element, MetaRelationConstants.RELATION_COLUMNKEY, meta.getColumnkey(), "");
		DomHelper.writeAttr(element, MetaRelationConstants.RELATION_ERROR_INFO, meta.getErrorInfo(), "");
	}

}
