package com.bokesoft.yes.meta.persist.dom.mobiledef;

import org.w3c.dom.Document;
import org.w3c.dom.Element;

import com.bokesoft.yes.meta.persist.dom.BaseDomAction;
import com.bokesoft.yes.meta.persist.dom.form.MetaConstants;
import com.bokesoft.yigo.common.dom.DomHelper;
import com.bokesoft.yigo.meta.mobiledef.MetaVibratorItem;

public class MetaVibratorItemAction extends BaseDomAction<MetaVibratorItem>{

	@Override
	public void load(Document document, Element element, MetaVibratorItem meta, int runType) {
		meta.setKey(DomHelper.readAttr(element, MetaConstants.COMMON_KEY, ""));
		meta.setMilliseconds(DomHelper.readAttr(element, MetaConstants.VIBRATORITEM_MILLISECONDS, 0));
		meta.setPattern(DomHelper.readAttr(element, MetaConstants.VIBRATORITEM_PATTERN, ""));
		meta.setRepeat(DomHelper.readAttr(element, MetaConstants.VIBRATORITEM_REPEAT, -1));
		meta.setDelayTime(DomHelper.readAttr(element, MetaConstants.VIBRATORITEM_DELAYTIME, 0));
	}

	@Override
	public void save(Document document, Element element, MetaVibratorItem meta, int runType) {
		DomHelper.writeAttr(element, MetaConstants.COMMON_KEY, meta.getKey(), "");
		DomHelper.writeAttr(element, MetaConstants.VIBRATORITEM_MILLISECONDS, meta.getMilliseconds(), 0);
		DomHelper.writeAttr(element, MetaConstants.VIBRATORITEM_PATTERN, meta.getPattern(), "");
		DomHelper.writeAttr(element, MetaConstants.VIBRATORITEM_REPEAT, meta.getRepeat(), -1);
		DomHelper.writeAttr(element, MetaConstants.VIBRATORITEM_DELAYTIME, meta.getDelayTime(), 0);
	}

}
