package com.bokesoft.yes.meta.persist.dom.form.dynamic;

import java.util.HashMap;

import org.w3c.dom.Document;
import org.w3c.dom.Element;

import com.bokesoft.yes.meta.persist.dom.BaseDomAction;
import com.bokesoft.yes.meta.persist.dom.form.MetaConstants;
import com.bokesoft.yes.meta.persist.dom.form.component.control.MetaDynamicPropertiesAction;
import com.bokesoft.yes.meta.persist.dom.form.component.control.properties.MetaBarCoderPropertiesAction;
import com.bokesoft.yes.meta.persist.dom.form.component.control.properties.MetaButtonPropertiesAction;
import com.bokesoft.yes.meta.persist.dom.form.component.control.properties.MetaCheckBoxPropertiesAction;
import com.bokesoft.yes.meta.persist.dom.form.component.control.properties.MetaCheckListBoxPropertiesAction;
import com.bokesoft.yes.meta.persist.dom.form.component.control.properties.MetaComboBoxPropertiesAction;
import com.bokesoft.yes.meta.persist.dom.form.component.control.properties.MetaComboViewPropertiesAction;
import com.bokesoft.yes.meta.persist.dom.form.component.control.properties.MetaCountDownViewPropertiesAction;
import com.bokesoft.yes.meta.persist.dom.form.component.control.properties.MetaCountUpPropertiesAction;
import com.bokesoft.yes.meta.persist.dom.form.component.control.properties.MetaCustomPropertiesAction;
import com.bokesoft.yes.meta.persist.dom.form.component.control.properties.MetaTimeCountDownPropertiesAction;
import com.bokesoft.yes.meta.persist.dom.form.component.control.properties.MetaDatePickerPropertiesAction;
import com.bokesoft.yes.meta.persist.dom.form.component.control.properties.MetaDictPropertiesAction;
import com.bokesoft.yes.meta.persist.dom.form.component.control.properties.MetaGIFImagePropertiesAction;
import com.bokesoft.yes.meta.persist.dom.form.component.control.properties.MetaHyperLinkPropertiesAction;
import com.bokesoft.yes.meta.persist.dom.form.component.control.properties.MetaImagePropertiesAction;
import com.bokesoft.yes.meta.persist.dom.form.component.control.properties.MetaLabelPropertiesAction;
import com.bokesoft.yes.meta.persist.dom.form.component.control.properties.MetaMultiStateButtonPropertiesAction;
import com.bokesoft.yes.meta.persist.dom.form.component.control.properties.MetaNoticeBarPropertiesAction;
import com.bokesoft.yes.meta.persist.dom.form.component.control.properties.MetaNumberEditorPropertiesAction;
import com.bokesoft.yes.meta.persist.dom.form.component.control.properties.MetaPopButtonPropertiesAction;
import com.bokesoft.yes.meta.persist.dom.form.component.control.properties.MetaPriceLabelPropertiesAction;
import com.bokesoft.yes.meta.persist.dom.form.component.control.properties.MetaProgressBarPropertiesAction;
import com.bokesoft.yes.meta.persist.dom.form.component.control.properties.MetaProgressIndicatorPropertiesAction;
import com.bokesoft.yes.meta.persist.dom.form.component.control.properties.MetaRelativeTimePropertiesAction;
import com.bokesoft.yes.meta.persist.dom.form.component.control.properties.MetaScoreBarPropertiesAction;
import com.bokesoft.yes.meta.persist.dom.form.component.control.properties.MetaSearchBoxPropertiesAction;
import com.bokesoft.yes.meta.persist.dom.form.component.control.properties.MetaSliderPropertiesAction;
import com.bokesoft.yes.meta.persist.dom.form.component.control.properties.MetaStepEditorPropertiesAction;
import com.bokesoft.yes.meta.persist.dom.form.component.control.properties.MetaSwitchPropertiesAction;
import com.bokesoft.yes.meta.persist.dom.form.component.control.properties.MetaTextAreaPropertiesAction;
import com.bokesoft.yes.meta.persist.dom.form.component.control.properties.MetaTextButtonPropertiesAction;
import com.bokesoft.yes.meta.persist.dom.form.component.control.properties.MetaTextEditorPropertiesAction;
import com.bokesoft.yes.meta.persist.dom.form.component.control.properties.MetaToggleButtonPropertiesAction;
import com.bokesoft.yes.meta.persist.dom.form.component.control.properties.MetaUploadButtonPropertiesAction;
import com.bokesoft.yes.meta.persist.dom.form.component.control.properties.MetaVideoPlayerPropertiesAction;
import com.bokesoft.yes.meta.persist.dom.form.component.control.properties.MetaWizardListPropertiesAction;
import com.bokesoft.yigo.common.def.CellType;
import com.bokesoft.yigo.common.def.ControlType;
import com.bokesoft.yigo.common.dom.DomHelper;
import com.bokesoft.yigo.meta.base.AbstractMetaObject;
import com.bokesoft.yigo.meta.form.component.grid.dynamic.MetaCellTypeDef;

public class MetaCellTypeDefAction extends BaseDomAction<MetaCellTypeDef>{
	
	private HashMap<Integer, BaseDomAction<AbstractMetaObject>> actionMap = null;
	@SuppressWarnings("unchecked")
	public MetaCellTypeDefAction() {
		super();
		actionMap = new HashMap<Integer, BaseDomAction<AbstractMetaObject>>();
		Object[][] v = new Object[][] {
			{ ControlType.TEXTAREA,new MetaTextAreaPropertiesAction()},
			{ ControlType.LABEL, new MetaLabelPropertiesAction() },
			{ ControlType.PRICELABEL, new MetaPriceLabelPropertiesAction() },
			{ ControlType.RELATIVETIME, new MetaRelativeTimePropertiesAction() },
			{ ControlType.BUTTON, new MetaButtonPropertiesAction() },
			{ ControlType.NOTICEBAR, new MetaNoticeBarPropertiesAction() },
			{ ControlType.BARCODER, new MetaBarCoderPropertiesAction() },
			{ ControlType.TOGGLEBUTTON, new MetaToggleButtonPropertiesAction() },
			{ ControlType.MULTISTATEBUTTON, new MetaMultiStateButtonPropertiesAction() },
			{ ControlType.COMBOVIEW, new MetaComboViewPropertiesAction() },
			{ ControlType.TEXTEDITOR, new MetaTextEditorPropertiesAction() },
			{ ControlType.TEXTBUTTON, new MetaTextButtonPropertiesAction() },
			{ ControlType.NUMBEREDITOR, new MetaNumberEditorPropertiesAction() },
			{ ControlType.CHECKBOX, new MetaCheckBoxPropertiesAction() },
			{ ControlType.DICT, new MetaDictPropertiesAction() },
			{ ControlType.DATEPICKER, new MetaDatePickerPropertiesAction() },
			{ ControlType.COMBOBOX, new MetaComboBoxPropertiesAction() },
			{ ControlType.CHECKLISTBOX, new MetaCheckListBoxPropertiesAction() },
			{ ControlType.IMAGE, new MetaImagePropertiesAction() },
			{ ControlType.VIDEOPLAYER, new MetaVideoPlayerPropertiesAction() },
			{ ControlType.HYPERLINK, new MetaHyperLinkPropertiesAction() },
			{ ControlType.COMPDICT,new MetaDictPropertiesAction()},
			{ ControlType.DYNAMICDICT,new MetaDictPropertiesAction()},
			{ ControlType.CUSTOM, new MetaCustomPropertiesAction() },
			{ ControlType.DYNAMIC, new MetaDynamicPropertiesAction() },
			{ ControlType.STEPEDITOR, new MetaStepEditorPropertiesAction() },
			{ ControlType.UPLOADBUTTON, new MetaUploadButtonPropertiesAction() },
			{ ControlType.SEARCHBOX, new MetaSearchBoxPropertiesAction() },
			{ ControlType.SCOREBAR, new MetaScoreBarPropertiesAction() },
			{ ControlType.SWITCH, new MetaSwitchPropertiesAction() },
			{ ControlType.POPBUTTON, new MetaPopButtonPropertiesAction() },
			{ ControlType.SLIDER, new MetaSliderPropertiesAction() },
			{ ControlType.PROGRESSBAR, new MetaProgressBarPropertiesAction()},
			{ ControlType.POPBUTTON, new MetaPopButtonPropertiesAction() },
			{ ControlType.NUMBERINFOEDITOR, new MetaNumberEditorPropertiesAction() },
			{ ControlType.COUNTDOWNVIEW, new MetaCountDownViewPropertiesAction() },
			{ ControlType.GIFIMAGE, new MetaGIFImagePropertiesAction() },
			{ ControlType.PROGRESSINDICATOR, new MetaProgressIndicatorPropertiesAction() },
			{ ControlType.COUNTUP, new MetaCountUpPropertiesAction() },
			{ ControlType.WIZARDLIST, new MetaWizardListPropertiesAction() },
			{ ControlType.TIMECOUNTDOWN, new MetaTimeCountDownPropertiesAction()}
	};
		int length = v.length;
		for ( int i = 0; i<length; ++i ) {
			Object[] l = v[i];
			Integer type = (Integer)l[0];
			BaseDomAction<AbstractMetaObject> action = (BaseDomAction<AbstractMetaObject>)l[1];
			actionMap.put(type, action);
		}
	}

	@Override
	public void load(Document document, Element element, MetaCellTypeDef meta, int runType) {
		meta.setKey(DomHelper.readAttr(element, MetaConstants.COMMON_KEY, ""));
		meta.setCaption(DomHelper.readAttr(element, MetaConstants.COMMON_CAPTION, ""));
		meta.setType(CellType.parse(DomHelper.readAttr(element, MetaConstants.CELL_TYPE, ControlType.STR_LABEL)));
		meta.setDefaultValue(DomHelper.readAttr(element, MetaConstants.COMMON_DEFAULTVALUE, ""));
		
		meta.ensureProperties();
		
		BaseDomAction<AbstractMetaObject> action = actionMap.get(meta.getType());
		if( action != null ) {
			action.load(document, element, meta.getProperties(), runType);
		}
	}

	@Override
	public void save(Document document, Element element, MetaCellTypeDef meta, int runType) {
		DomHelper.writeAttr(element, MetaConstants.COMMON_KEY, meta.getKey(), "");
		DomHelper.writeAttr(element, MetaConstants.COMMON_CAPTION, meta.getCaption(), "");
		DomHelper.writeAttr(element, MetaConstants.CELL_TYPE, CellType.toString(meta.getType()), ControlType.STR_LABEL);
		DomHelper.writeAttr(element, MetaConstants.COMMON_DEFAULTVALUE, meta.getDefaultValue(), "");
		
		meta.ensureProperties();
		BaseDomAction<AbstractMetaObject> action = actionMap.get(meta.getType());
		if( action != null ) {
			action.save(document, element, meta.getProperties(), runType);
		}
	}

}
