package com.bokesoft.yes.meta.persist.dom.form.component.view.layout;

import org.w3c.dom.Document;
import org.w3c.dom.Element;

import com.bokesoft.yes.meta.persist.dom.form.MetaConstants;
import com.bokesoft.yigo.common.dom.DomHelper;
import com.bokesoft.yigo.meta.base.AbstractMetaObject;
import com.bokesoft.yigo.meta.form.component.view.layout.MetaLayoutTabItem;

public class MetaLayoutTabItemAction extends MetaLayoutItemAction {
	@Override
	public void load(Document document, Element element,
			AbstractMetaObject meta, int runType) {
		super.load(document, element, meta, runType);
		MetaLayoutTabItem metaLayoutTabItem = (MetaLayoutTabItem)meta;
		metaLayoutTabItem.setCaption(DomHelper.readAttr(element, MetaConstants.COMMON_CAPTION, ""));
	}

	@Override
	public void save(Document document, Element element,
			AbstractMetaObject meta, int runType) {
		super.save(document, element, meta, runType);
		MetaLayoutTabItem metaLayoutTabItem = (MetaLayoutTabItem)meta;
		DomHelper.writeAttr(element, MetaConstants.COMMON_CAPTION, metaLayoutTabItem.getCaption(), "");
	}
}
