package com.bokesoft.yes.meta.persist.dom.form.component.view;

import org.w3c.dom.Document;
import org.w3c.dom.Element;

import com.bokesoft.yes.meta.persist.dom.BaseDomAction;
import com.bokesoft.yes.meta.persist.dom.form.MetaConstants;
import com.bokesoft.yigo.common.def.Media;
import com.bokesoft.yigo.common.dom.DomHelper;
import com.bokesoft.yigo.meta.form.component.view.MetaView;

public class MetaViewAction extends BaseDomAction<MetaView> {

	@Override
	public void load(Document document, Element element, MetaView meta,
			int runType) {
		meta.setKey(DomHelper.readAttr(element, MetaConstants.COMMON_KEY, ""));
		meta.setCaption(DomHelper.readAttr(element, MetaConstants.COMMON_CAPTION, ""));
		meta.setMedia(Media.valueOf(DomHelper.readAttr(element, MetaConstants.VIEW_MEDIA, "")));
		meta.setRule(DomHelper.readAttr(element, MetaConstants.VIEW_RULE, ""));
		meta.setSize(DomHelper.readAttr(element, MetaConstants.VIEW_SIZE, ""));
	}

	@Override
	public void save(Document document, Element element, MetaView meta,
			int runType) {
		DomHelper.writeAttr(element, MetaConstants.COMMON_KEY, meta.getKey(), "");
		DomHelper.writeAttr(element, MetaConstants.COMMON_CAPTION, meta.getCaption(), "");
		DomHelper.writeAttr(element, MetaConstants.VIEW_MEDIA, Media.toString(meta.getMedia()), "");
		DomHelper.writeAttr(element, MetaConstants.VIEW_RULE, meta.getRule(), "");
	}

}
