package com.bokesoft.yes.meta.persist.dom.form.component.theme;

import org.w3c.dom.Document;
import org.w3c.dom.Element;

import com.bokesoft.yes.meta.persist.dom.BaseDomAction;
import com.bokesoft.yes.meta.persist.dom.form.MetaConstants;
import com.bokesoft.yigo.common.dom.DomHelper;
import com.bokesoft.yigo.meta.form.component.theme.MetaThemeCollection;

public class MetaThemeCollectionAction extends BaseDomAction<MetaThemeCollection> {

	@Override
	public void load(Document document, Element element,
			MetaThemeCollection meta, int runType) {
		meta.setDefaultTheme(DomHelper.readAttr(element, MetaConstants.THEME_DEFAULT, ""));
	}

	@Override
	public void save(Document document, Element element,
			MetaThemeCollection meta, int runType) {
		DomHelper.writeAttr(element, MetaConstants.THEME_DEFAULT, meta.getDefaultTheme(), "");
	}

}
