package com.bokesoft.yes.meta.persist.dom.form.component.theme;

import org.w3c.dom.Document;
import org.w3c.dom.Element;

import com.bokesoft.yes.meta.persist.dom.BaseDomAction;
import com.bokesoft.yes.meta.persist.dom.form.MetaConstants;
import com.bokesoft.yigo.common.dom.DomHelper;
import com.bokesoft.yigo.meta.form.component.theme.MetaTheme;

public class MetaThemeAction extends BaseDomAction<MetaTheme> {

	@Override
	public void load(Document document, Element element, MetaTheme meta, int runType) {
		meta.setKey(DomHelper.readAttr(element, MetaConstants.COMMON_KEY, ""));
		meta.setCaption(DomHelper.readAttr(element, MetaConstants.COMMON_CAPTION, ""));
		meta.setMedia(DomHelper.readAttr(element, MetaConstants.THEME_MEDIA, ""));
		meta.setRule(DomHelper.readAttr(element, MetaConstants.THEME_RULE, ""));
		meta.setCssFile(DomHelper.readAttr(element, MetaConstants.THEME_CSSFILE, ""));
	}

	@Override
	public void save(Document document, Element element, MetaTheme meta, int runType) {
		DomHelper.writeAttr(element, MetaConstants.COMMON_KEY, meta.getKey(), "");
		DomHelper.writeAttr(element, MetaConstants.COMMON_CAPTION, meta.getCaption(), "");
		DomHelper.writeAttr(element, MetaConstants.THEME_MEDIA, meta.getMedia(), "");
		DomHelper.writeAttr(element, MetaConstants.THEME_RULE, meta.getRule(), "");
		DomHelper.writeAttr(element, MetaConstants.THEME_CSSFILE, meta.getCssFile(), "");
	}
}
