package com.bokesoft.yes.meta.persist.dom.form.component.panel;

import org.w3c.dom.Document;
import org.w3c.dom.Element;

import com.bokesoft.yes.meta.persist.dom.form.MetaConstants;
import com.bokesoft.yigo.common.def.DefSize;
import com.bokesoft.yigo.common.def.DirectionType;
import com.bokesoft.yigo.common.def.TabMode;
import com.bokesoft.yigo.common.dom.DomHelper;
import com.bokesoft.yigo.meta.form.component.panel.MetaTabPanel;

/**
 * 分页布局面板在保存和载入时的相关动作
 * 
 * @author chenzs
 * @since YES1.0
 */
public class MetaTabPanelAction extends MetaPanelAction<MetaTabPanel> {
	@Override
	public void load(Document document, Element element, MetaTabPanel meta, int runType) {
		super.load(document, element, meta, runType);
		meta.setTabPosition(DirectionType.parse(DomHelper.readAttr(element, MetaConstants.TABPANEL_TABPOSITION, DirectionType.STR_TOP)));
		meta.setTabMode(TabMode.parse(DomHelper.readAttr(element, MetaConstants.TABPANEL_TABMODE, TabMode.STR_Fixed)));
		meta.setIndicatorHeight(DefSize.parse(DomHelper.readAttr(element, MetaConstants.TABPANEL_INDICATORHEIGHT, null)));
		meta.setIndicatorColor(DomHelper.readAttr(element, MetaConstants.TABPANEL_INDICATORCOLOR, ""));
		meta.setShowHead(DomHelper.readBool(element, MetaConstants.TABPANEL_SHOWHEAD, true));
		meta.setHoverHead(DomHelper.readBool(element, MetaConstants.TABPANEL_HOVERHEAD, false));
	}

	@Override
	public void save(Document document, Element element, MetaTabPanel meta, int runType) {
		super.save(document, element, meta, runType);
		DomHelper.writeAttr(element, MetaConstants.TABPANEL_TABPOSITION, DirectionType.toString(meta.getTabPosition()), DirectionType.STR_TOP);
		DomHelper.writeAttr(element, MetaConstants.TABPANEL_TABMODE, TabMode.toString(meta.getTabMode()), TabMode.STR_Fixed);
		DomHelper.writeAttr(element, MetaConstants.TABPANEL_INDICATORHEIGHT, 
				meta.getIndicatorHeight() == null ? "" : meta.getIndicatorHeight().toString(), "");
		DomHelper.writeAttr(element, MetaConstants.TABPANEL_INDICATORCOLOR, meta.getIndicatorColor(), "");
		DomHelper.writeAttr(element, MetaConstants.TABPANEL_SHOWHEAD, meta.isShowHead(), true);
		DomHelper.writeAttr(element, MetaConstants.TABPANEL_HOVERHEAD, meta.isHoverHead(), false);
	}
}
