package com.bokesoft.yes.meta.persist.dom.form.component.html;

import org.w3c.dom.Document;
import org.w3c.dom.Element;

import com.bokesoft.yes.meta.persist.dom.form.MetaConstants;
import com.bokesoft.yigo.common.dom.DomHelper;
import com.bokesoft.yigo.meta.form.component.html.MetaHtml_A;

/**
 * Html元素< a >对象在载入和保存时的动作
 * 
 * @author 陈志盛
 * @since YES1.0
 */
public class MetaHtml_A_Action extends MetaHtmlElementAction<MetaHtml_A> {
	@Override
	public void load(Document document, Element element, MetaHtml_A meta, int runType) {
		super.load(document, element, meta, runType);
		meta.setHrefURL(DomHelper.readAttr(element, MetaConstants.HTML_A_HREF, ""));
		meta.setTargetType(meta.parseType(DomHelper.readAttr(element, MetaConstants.HTML_A_TARGET, "Blank")));
	}

	@Override
	public void save(Document document, Element element, MetaHtml_A meta, int runType) {
		super.save(document, element, meta, runType);
		DomHelper.writeAttr(element, MetaConstants.HTML_A_HREF, meta.getHrefURL(), "");
		DomHelper.writeAttr(element, MetaConstants.HTML_A_TARGET, meta.getTargetTypeStr(), "Blank");
	}
}
