package com.bokesoft.yes.meta.persist.dom.form.component.control.tableview;

import org.w3c.dom.Document;
import org.w3c.dom.Element;

import com.bokesoft.yes.meta.persist.dom.form.MetaConstants;
import com.bokesoft.yes.meta.persist.dom.form.component.MetaComponentAction;
import com.bokesoft.yigo.common.def.ItemAnimType;
import com.bokesoft.yigo.common.dom.DomHelper;
import com.bokesoft.yigo.meta.form.component.control.tableview.MetaTableView;

public class MetaTableViewAction extends MetaComponentAction<MetaTableView> {

	@Override
	public void load(Document document, Element element, MetaTableView meta, int runType) {
		super.load(document, element, meta, runType);
		meta.setItemAnim(DomHelper.readAttr(element, MetaConstants.LISTVIEW_ITEMANIM, ItemAnimType.FADEIN));
		meta.setLayoutAnim(DomHelper.readAttr(element, MetaConstants.COMPONENT_LAYOUTANIM, ""));
	}

	@Override
	public void save(Document document, Element element, MetaTableView meta, int runType) {
		super.save(document, element, meta, runType);
		DomHelper.writeAttr(element, MetaConstants.LISTVIEW_ITEMANIM, meta.getItemAnim(), ItemAnimType.FADEIN);
		DomHelper.writeAttr(element, MetaConstants.COMPONENT_LAYOUTANIM, meta.getLayoutAnim(), "");
	}

}
