package com.bokesoft.yes.meta.persist.dom.form.component.control.properties.extend;

import org.w3c.dom.Document;
import org.w3c.dom.Element;

import com.bokesoft.yes.meta.persist.dom.form.MetaConstants;
import com.bokesoft.yes.meta.persist.dom.form.component.control.properties.DomPropertiesAction;
import com.bokesoft.yigo.common.def.StepEditorEditType;
import com.bokesoft.yigo.common.dom.DomHelper;
import com.bokesoft.yigo.common.util.TypeConvertor;
import com.bokesoft.yigo.meta.form.component.control.properties.MetaStepEditorProperties;

public class MetaStepEditorExtPropertiesAction extends DomPropertiesAction<MetaStepEditorProperties> {

	@Override
	public void loadImpl(Document document, Element element, MetaStepEditorProperties meta, int runType) {
		String minValue = DomHelper.readAttr(element, MetaConstants.STEPEDITOR_MINVALUE, null);
		if (minValue != null && !minValue.isEmpty()) {
			meta.setMinValue(TypeConvertor.toBigDecimal(minValue));
		}else{
			meta.setMinValue(null);
		}
		String maxValue = DomHelper.readAttr(element, MetaConstants.STEPEDITOR_MAXVALUE, null);
		if (maxValue != null && !maxValue.isEmpty()) {
			meta.setMaxValue(TypeConvertor.toBigDecimal(maxValue));
		}else{
			meta.setMaxValue(null);
		}
		String step = DomHelper.readAttr(element, MetaConstants.STEPEDITOR_STEP, null);
		if(step != null && !step.isEmpty()){
			meta.setStep(TypeConvertor.toBigDecimal(step));
		}else{
			meta.setStep(null);
		}
		meta.setEditType(StepEditorEditType.parse(DomHelper.readAttr(element, MetaConstants.STEPEDITOR_EDITTYPE, "")));	
		meta.setDisableKeyboard(DomHelper.readBool(element, MetaConstants.STEPEDITOR_DISABLEKEYBOARD, null));

	}

	@Override
	public void saveImpl(Document document, Element element, MetaStepEditorProperties meta, int runType) {
		// TODO Auto-generated method stub
		
	}

}
