package com.bokesoft.yes.meta.persist.dom.form.component.control.properties.extend;

import com.bokesoft.yigo.common.def.SelectEditType;
import com.bokesoft.yigo.common.def.SelectStyle;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

import com.bokesoft.yes.meta.persist.dom.form.MetaConstants;
import com.bokesoft.yes.meta.persist.dom.form.component.control.properties.DomPropertiesAction;
import com.bokesoft.yigo.common.def.ComboBoxSourceType;
import com.bokesoft.yigo.common.def.ComboBoxTextShowType;
import com.bokesoft.yigo.common.dom.DomHelper;
import com.bokesoft.yigo.meta.form.component.control.properties.MetaCheckListBoxProperties;

public class MetaCheckListBoxExtPropertiesAction extends DomPropertiesAction<MetaCheckListBoxProperties> {

	@Override
	public void loadImpl(Document document, Element element, MetaCheckListBoxProperties meta, int runType) {
		meta.setItemsDependency(DomHelper.readAttr(element, MetaConstants.COMBOBOX_ITEMS_DEPENDENCY, null));
		meta.setSourceType(ComboBoxSourceType.parse(DomHelper.readAttr(element, MetaConstants.COMBOBOX_SOURCETYPE,"")));
		meta.setGroupKey(DomHelper.readAttr(element, MetaConstants.GROUP_KEY, null));
		meta.setGlobalItems(DomHelper.readAttr(element, MetaConstants.COMBOBOX_GLOBAL_ITEMS, null));
		meta.setPromptText(DomHelper.readAttr(element, MetaConstants.COMBOBOX_PROMPTTEXT, null));
		meta.setStyle(SelectStyle.parse(DomHelper.readAttr(element, MetaConstants.COMBOBOX_STYLE,"")));
		meta.setEditType(SelectEditType.parse(DomHelper.readAttr(element, MetaConstants.COMBOBOX_EDITTYPE, "")));
		meta.setColumnCount(DomHelper.readAttr(element, MetaConstants.COMBOBOX_COLUMNCOUNT, -1));
		meta.setPopAnim(DomHelper.readAttr(element, MetaConstants.COMMON_POPANIM, null));
		meta.setCache(DomHelper.readBool(element, MetaConstants.COMBOBOX_CACHE, null));
		meta.setCssClass(DomHelper.readAttr(element, MetaConstants.OPERATION_CSSCLASS, null));
		meta.setTextShowType(ComboBoxTextShowType.parse(DomHelper.readAttr(element, MetaConstants.COMBOBOX_TEXTSHOWTYPE, "")));
	}

	@Override
	public void saveImpl(Document document, Element element, MetaCheckListBoxProperties meta, int runType) {
		
	}

}