package com.bokesoft.yes.meta.persist.dom.form.component.control.properties;

import com.bokesoft.yes.meta.persist.dom.form.MetaConstants;
import com.bokesoft.yigo.common.def.IconLocationType;
import com.bokesoft.yigo.common.dom.DomHelper;
import com.bokesoft.yigo.meta.form.component.control.properties.MetaRadioButtonProperties;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class MetaRadioButtonPropertiesAction extends DomPropertiesAction<MetaRadioButtonProperties> {

	@Override
	public void loadImpl(Document document, Element element,
						 MetaRadioButtonProperties meta, int runType) {
		meta.setGroupKey(DomHelper.readAttr(element, MetaConstants.RADIOBUTTON_GROUPKEY, ""));
		meta.setGroupHead(DomHelper.readAttr(element, MetaConstants.RADIOBUTTON_ISGROUPHEAD, false));
		meta.setSelectedValue(DomHelper.readAttr(element, MetaConstants.RADIOBUTTON_VALUE, ""));
		meta.setIcon(DomHelper.readAttr(element, MetaConstants.CHECKBOX_ICON, ""));
		meta.setSelectedIcon(DomHelper.readAttr(element, MetaConstants.CHECKBOX_SELECTEDICON, ""));
		meta.setIconLocation(IconLocationType.parse(DomHelper.readAttr(element, MetaConstants.CHECKBOX_ICONLOCATION, IconLocationType.STR_LEFT)));
		meta.setHideButton(DomHelper.readAttr(element, MetaConstants.CHECKBOX_HIDEBUTTON, false));
	}
	
	@Override
	public void saveImpl(Document document, Element element,
						 MetaRadioButtonProperties meta, int runType) {
		DomHelper.writeAttr(element, MetaConstants.RADIOBUTTON_GROUPKEY, meta.getGroupKey(), "");
		DomHelper.writeAttr(element, MetaConstants.RADIOBUTTON_ISGROUPHEAD, meta.getGroupHead(), false);
		DomHelper.writeAttr(element, MetaConstants.RADIOBUTTON_VALUE, meta.getSelectedValue(), "");
		DomHelper.writeAttr(element, MetaConstants.CHECKBOX_ICON, meta.getIcon(), "");
		DomHelper.writeAttr(element, MetaConstants.CHECKBOX_SELECTEDICON, meta.getSelectedIcon(), "");
		DomHelper.writeAttr(element, MetaConstants.CHECKBOX_ICONLOCATION, IconLocationType.toString(meta.getIconLocation()), IconLocationType.STR_LEFT);
		DomHelper.writeAttr(element, MetaConstants.CHECKBOX_HIDEBUTTON, meta.getHideButton(), false);
	}

}
