package com.bokesoft.yes.meta.persist.dom.form.component.control.properties;

import org.w3c.dom.Document;
import org.w3c.dom.Element;

import com.bokesoft.yes.meta.persist.dom.form.MetaConstants;
import com.bokesoft.yigo.common.def.ImageScaleType;
import com.bokesoft.yigo.common.def.ImageSourceType;
import com.bokesoft.yigo.common.def.ImageViewMode;
import com.bokesoft.yigo.common.def.UploadProgressType;
import com.bokesoft.yigo.common.dom.DomHelper;
import com.bokesoft.yigo.meta.form.component.control.properties.MetaImageProperties;

public class MetaImagePropertiesAction extends DomPropertiesAction<MetaImageProperties> {

	@Override
	public void loadImpl(Document document, Element element,
			MetaImageProperties meta, int runType) {
		meta.setSourceType(ImageSourceType.parse(DomHelper.readAttr(element, MetaConstants.PICTURE_SOURCETYPE, "Data")));
		meta.setImage(DomHelper.readAttr(element, MetaConstants.PICTURE_IMAGE, ""));
		meta.setImageScaleType(ImageScaleType.parse(DomHelper.readAttr(element, MetaConstants.PICTURE_IMAGESCALETYPE, "")));
		// 与移动端统一
		if(meta.getImageScaleType() == -1) {
			boolean stretch = DomHelper.readAttr(element, MetaConstants.PICTURE_STRETCH, false);
			if(stretch) {
				meta.setImageScaleType(ImageScaleType.FIT_XY);
			}
		}
		meta.setStretch(DomHelper.readAttr(element, MetaConstants.PICTURE_STRETCH, false));
		meta.setMaxSize(DomHelper.readAttr(element, MetaConstants.PICTURE_MAXSIZE, -1));
		meta.setImageCut(DomHelper.readAttr(element, MetaConstants.PICTURE_IMAGECUT, false));
		
		meta.setPromptImage(DomHelper.readAttr(element, MetaConstants.PICTURE_PROMPTIMAGE, ""));
		meta.setRadius(DomHelper.readAttr(element, MetaConstants.PICTURE_RADIUS, -1));
		meta.setFileName(DomHelper.readAttr(element, MetaConstants.PICTURE_FILENAME, ""));
		meta.setViewMode(ImageViewMode.parse(DomHelper.readAttr(element, MetaConstants.PICTURE_VIEWMODE, ImageViewMode.STR_SELF)));
		meta.setViewOpt(DomHelper.readAttr(element, MetaConstants.PICTURE_VIEWOPT, false));
		meta.setMaskImage(DomHelper.readAttr(element, MetaConstants.PICTURE_MASKIMAGE, ""));
		meta.setShowThumbnail(DomHelper.readAttr(element, MetaConstants.PICTURE_SHOWTHUMBNAIL, true));
		meta.setUploadProgress(UploadProgressType.parse(DomHelper.readAttr(element, MetaConstants.PICTURE_UPLOADPROGRESS, UploadProgressType.STR_None)));
		meta.setMaxShowSize(DomHelper.readInt(element, MetaConstants.PICTURE_MAXSHOWSIZE, 10000));
	}
	
	@Override
	public void saveImpl(Document document, Element element,
			MetaImageProperties meta, int runType) {
		DomHelper.writeAttr(element, MetaConstants.PICTURE_IMAGE, meta.getImage(), "");
		DomHelper.writeAttr(element, MetaConstants.PICTURE_SOURCETYPE, ImageSourceType.toString(meta.getSourceType()), "Data");
		DomHelper.writeAttr(element, MetaConstants.PICTURE_STRETCH, meta.isStretch(), false);
		DomHelper.writeAttr(element, MetaConstants.PICTURE_MAXSIZE, meta.getMaxSize(), -1);
		DomHelper.writeAttr(element, MetaConstants.PICTURE_IMAGECUT, meta.isImageCut(), false);
		DomHelper.writeAttr(element, MetaConstants.PICTURE_IMAGESCALETYPE, ImageScaleType.toString(meta.getImageScaleType()),"");
		DomHelper.writeAttr(element, MetaConstants.PICTURE_PROMPTIMAGE, meta.getPromptImage(), "");
		DomHelper.writeAttr(element, MetaConstants.PICTURE_RADIUS, meta.getRadius(), -1);
		DomHelper.writeAttr(element, MetaConstants.PICTURE_FILENAME, meta.getFileName(), "");
		DomHelper.writeAttr(element, MetaConstants.PICTURE_VIEWMODE, ImageViewMode.toString(meta.getViewMode()), ImageViewMode.STR_SELF);
		DomHelper.writeAttr(element, MetaConstants.PICTURE_VIEWOPT, meta.isViewOpt(), false);
		DomHelper.writeAttr(element, MetaConstants.PICTURE_MASKIMAGE, meta.getMaskImage(), "");
		DomHelper.writeAttr(element, MetaConstants.PICTURE_SHOWTHUMBNAIL, meta.isShowThumbnail(), true);
		DomHelper.writeAttr(element, MetaConstants.PICTURE_UPLOADPROGRESS, UploadProgressType.toString(meta.getUploadProgress()), UploadProgressType.STR_None);
		DomHelper.writeAttr(element, MetaConstants.PICTURE_MAXSHOWSIZE, meta.getMaxShowSize(), 10000);
	}

}
