package com.bokesoft.yes.meta.persist.dom.form.component.control.properties;

import org.w3c.dom.Document;
import org.w3c.dom.Element;

import com.bokesoft.yes.meta.persist.dom.form.MetaConstants;
import com.bokesoft.yigo.common.def.ImageScaleType;
import com.bokesoft.yigo.common.dom.DomHelper;
import com.bokesoft.yigo.meta.form.component.control.properties.MetaImageListProperties;

public class MetaImageListPropertiesAction extends DomPropertiesAction<MetaImageListProperties> {

	@Override
	public void loadImpl(Document document, Element element, MetaImageListProperties meta, int runType) {
//		meta.setStretch(DomHelper.readAttr(element, MetaConstants.PICTURE_STRETCH, false));
		meta.setImageScaleType(
				ImageScaleType.parse(DomHelper.readAttr(element, MetaConstants.PICTURE_IMAGESCALETYPE, "")));
		meta.setPromptImage(DomHelper.readAttr(element, MetaConstants.PICTURE_PROMPTIMAGE, ""));
		meta.setRadius(DomHelper.readAttr(element, MetaConstants.PICTURE_RADIUS, -1));
		meta.setMaskImage(DomHelper.readAttr(element, MetaConstants.PICTURE_MASKIMAGE, ""));
	}

	@Override
	public void saveImpl(Document document, Element element, MetaImageListProperties meta, int runType) {
//		DomHelper.writeAttr(element, MetaConstants.PICTURE_STRETCH, meta.isStretch(), false);
		DomHelper.writeAttr(element, MetaConstants.PICTURE_IMAGESCALETYPE,
				ImageScaleType.toString(meta.getImageScaleType()), "");
		DomHelper.writeAttr(element, MetaConstants.PICTURE_PROMPTIMAGE, meta.getPromptImage(), "");
		DomHelper.writeAttr(element, MetaConstants.PICTURE_RADIUS, meta.getRadius(), -1);
		DomHelper.writeAttr(element, MetaConstants.PICTURE_MASKIMAGE, meta.getMaskImage(), "");
	}

}
