package com.bokesoft.yes.meta.persist.dom.form.component.control.properties;

import org.w3c.dom.Document;
import org.w3c.dom.Element;

import com.bokesoft.yes.meta.persist.dom.form.MetaConstants;
import com.bokesoft.yigo.common.def.ImageScaleType;
import com.bokesoft.yigo.common.dom.DomHelper;
import com.bokesoft.yigo.meta.form.component.control.properties.MetaIconProperties;

public class MetaIconPropertiesAction extends DomPropertiesAction<MetaIconProperties> {

	@Override
	public void loadImpl(Document document, Element element, MetaIconProperties meta, int runType) {
		meta.setIcon(DomHelper.readAttr(element, MetaConstants.COMMON_ICON, ""));
		meta.setUrl(DomHelper.readAttr(element, MetaConstants.ICON_URL, ""));
		meta.setImageScaleType(ImageScaleType.parse(DomHelper.readAttr(element, MetaConstants.PICTURE_IMAGESCALETYPE, "")));
	}

	@Override
	public void saveImpl(Document document, Element element, MetaIconProperties meta, int runType) {
		DomHelper.writeAttr(element, MetaConstants.COMMON_ICON, meta.getIcon(), "");
		DomHelper.writeAttr(element, MetaConstants.ICON_URL, meta.getUrl(), "");
		DomHelper.writeAttr(element, MetaConstants.PICTURE_IMAGESCALETYPE, ImageScaleType.toString(meta.getImageScaleType()),"");
	}

}
