package com.bokesoft.yes.meta.persist.dom.form.component.control.properties;

import org.w3c.dom.Document;
import org.w3c.dom.Element;
import com.bokesoft.yes.meta.persist.dom.form.MetaConstants;
import com.bokesoft.yigo.common.def.IconLocationType;
import com.bokesoft.yigo.common.dom.DomHelper;
import com.bokesoft.yigo.meta.form.component.control.properties.MetaComboViewProperties;

public class MetaComboViewPropertiesAction extends DomPropertiesAction<MetaComboViewProperties> {

	@Override
	public void loadImpl(Document document, Element element, MetaComboViewProperties meta, int runType) {
		meta.setIcon(DomHelper.readAttr(element, MetaConstants.COMBOVIEW_ICON, ""));
		meta.setIconLocation(IconLocationType.parse(
				DomHelper.readAttr(element, MetaConstants.COMBOVIEW_ICONLOCATION, IconLocationType.STR_LEFT)));
	}

	@Override
	public void saveImpl(Document document, Element element, MetaComboViewProperties meta, int runType) {
		DomHelper.writeAttr(element, MetaConstants.COMBOVIEW_ICON, meta.getIcon(), "");
		DomHelper.writeAttr(element, MetaConstants.COMBOVIEW_ICONLOCATION, 
				IconLocationType.toString(meta.getIconLocation()), IconLocationType.STR_LEFT);
	}

}
