package com.bokesoft.yes.meta.persist.dom.form.component.control.properties;

import org.w3c.dom.Document;
import org.w3c.dom.Element;

import com.bokesoft.yes.meta.persist.dom.form.MetaConstants;
import com.bokesoft.yigo.common.def.ComboBoxSourceType;
import com.bokesoft.yigo.common.def.ComboBoxTextShowType;
import com.bokesoft.yigo.common.def.SelectEditType;
import com.bokesoft.yigo.common.def.SelectStyle;
import com.bokesoft.yigo.common.dom.DomHelper;
import com.bokesoft.yigo.meta.form.component.control.properties.MetaCheckListBoxProperties;

public class MetaCheckListBoxPropertiesAction extends DomPropertiesAction<MetaCheckListBoxProperties> {

	@Override
	public void loadImpl(Document document, Element element,
			MetaCheckListBoxProperties meta, int runType) {
		meta.setItemsDependency(DomHelper.readAttr(element, MetaConstants.COMBOBOX_ITEMS_DEPENDENCY, ""));
		meta.setSourceType(ComboBoxSourceType.parse(DomHelper.readAttr(element, MetaConstants.COMBOBOX_SOURCETYPE, ComboBoxSourceType.STR_ITEMS)));
		meta.setGroupKey(DomHelper.readAttr(element, MetaConstants.GROUP_KEY, ""));
		meta.setGlobalItems(DomHelper.readAttr(element, MetaConstants.COMBOBOX_GLOBAL_ITEMS, ""));
		meta.setPromptText(DomHelper.readAttr(element, MetaConstants.COMBOBOX_PROMPTTEXT, ""));
		meta.setStyle(SelectStyle.parse(DomHelper.readAttr(element, MetaConstants.COMBOBOX_STYLE, SelectStyle.STR_POP)));
		meta.setEditType(SelectEditType.parse(DomHelper.readAttr(element, MetaConstants.COMBOBOX_EDITTYPE, SelectEditType.STR_DIALOG)));
		meta.setColumnCount(DomHelper.readAttr(element, MetaConstants.COMBOBOX_COLUMNCOUNT, MetaCheckListBoxProperties.DEFAULT_COLUMN_COUNT));
		meta.setPopAnim(DomHelper.readAttr(element, MetaConstants.COMMON_POPANIM, ""));
		meta.setCache(DomHelper.readAttr(element, MetaConstants.COMBOBOX_CACHE, true));
		meta.setCssClass(DomHelper.readAttr(element, MetaConstants.OPERATION_CSSCLASS, ""));
		meta.setTextShowType(ComboBoxTextShowType.parse(DomHelper.readAttr(element, MetaConstants.COMBOBOX_TEXTSHOWTYPE, ComboBoxTextShowType.STR_UNDEFINED)));
	}
	
	@Override
	public void saveImpl(Document document, Element element,
			MetaCheckListBoxProperties meta, int runType) {
		DomHelper.writeAttr(element, MetaConstants.COMBOBOX_ITEMS_DEPENDENCY, meta.getItemsDependency(), "");
		DomHelper.writeAttr(element, MetaConstants.COMBOBOX_SOURCETYPE, ComboBoxSourceType.format(meta.getSourceType()), ComboBoxSourceType.STR_ITEMS);
		DomHelper.writeAttr(element, MetaConstants.GROUP_KEY, meta.getGroupKey(), "");
		DomHelper.writeAttr(element, MetaConstants.COMBOBOX_GLOBAL_ITEMS, meta.getGlobalItems(), "");
		DomHelper.writeAttr(element, MetaConstants.COMBOBOX_PROMPTTEXT, meta.getPromptText(),"");
		DomHelper.writeAttr(element, MetaConstants.COMBOBOX_STYLE, SelectStyle.format(meta.getStyle()), SelectStyle.STR_POP);
		DomHelper.writeAttr(element, MetaConstants.COMBOBOX_EDITTYPE, SelectEditType.format(meta.getEditType()), SelectEditType.STR_DIALOG);
		DomHelper.writeAttr(element, MetaConstants.COMBOBOX_COLUMNCOUNT, meta.getColumnCount(), MetaCheckListBoxProperties.DEFAULT_COLUMN_COUNT);
		DomHelper.writeAttr(element, MetaConstants.COMMON_POPANIM, meta.getPopAnim(), "");
		DomHelper.writeAttr(element, MetaConstants.COMBOBOX_CACHE, meta.getCache(), true);
		DomHelper.writeAttr(element, MetaConstants.OPERATION_CSSCLASS, meta.getCssClass(), "");
		DomHelper.writeAttr(element, MetaConstants.COMBOBOX_TEXTSHOWTYPE, ComboBoxTextShowType.format(meta.getTextShowType()), ComboBoxTextShowType.STR_UNDEFINED);
	}

}