package com.bokesoft.yes.meta.persist.dom.form.component.control.properties;

import org.w3c.dom.Document;
import org.w3c.dom.Element;

import com.bokesoft.yes.meta.persist.dom.form.MetaConstants;
import com.bokesoft.yigo.common.def.ButtonType;
import com.bokesoft.yigo.common.def.IconLocationType;
import com.bokesoft.yigo.common.dom.DomHelper;
import com.bokesoft.yigo.common.util.TypeConvertor;
import com.bokesoft.yigo.meta.form.component.control.properties.MetaButtonProperties;

public class MetaButtonPropertiesAction extends DomPropertiesAction<MetaButtonProperties> {
	@Override
	public void loadImpl(Document document, Element element,
			MetaButtonProperties meta, int runType) {
		meta.setIcon(DomHelper.readAttr(element, MetaConstants.BUTTON_ICON, ""));
		meta.setIconLocation(IconLocationType.parse(
				DomHelper.readAttr(element, MetaConstants.BUTTON_ICONLOCATION, IconLocationType.STR_LEFT)));
		meta.setOnlyIcon(DomHelper.readAttr(element, MetaConstants.BUTTON_ONLYICON, false));
		meta.setNeedAccessLog(DomHelper.readAttr(element, MetaConstants.BUTTON_NEEDACCESSLOG, false));
		meta.setNeedAuthenticate(DomHelper.readBool(element, MetaConstants.BUTTON_NEEDAUTHENTICATE, false));
		meta.setClickAnim(DomHelper.readAttr(element, MetaConstants.BUTTON_CLICKANIM, ""));
		meta.setUploadFile(DomHelper.readBool(element, MetaConstants.BUTTON_UPLOADFILE, false));
		meta.setUploadType(DomHelper.readAttr(element, MetaConstants.BUTTON_UPLOADTYPE, "single"));
		meta.setType(ButtonType.parse(DomHelper.readAttr(element, MetaConstants.BUTTON_TYPE, ButtonType.STR_NORMAL)));
		meta.setIconCode(DomHelper.readAttr(element, MetaConstants.COMMON_ICON_CODE, ""));
		meta.setTCode(DomHelper.readAttr(element, MetaConstants.BUTTON_TCODE, ""));
		meta.setActivity(DomHelper.readAttr(element, MetaConstants.BUTTON_ACTIVITY, ""));
		meta.setCheckOnClickNode(DomHelper.readAttr(element, MetaConstants.COMMON_CHECK_ON_CLICK_NODE, false));
	}

	@Override
	public void saveImpl(Document document, Element element,
			MetaButtonProperties meta, int runType) {
		DomHelper.writeAttr(element, MetaConstants.BUTTON_ICON, meta.getIcon(), "");
		DomHelper.writeAttr(element, MetaConstants.BUTTON_ICONLOCATION, 
				IconLocationType.toString(meta.getIconLocation()), IconLocationType.STR_LEFT);
		DomHelper.writeAttr(element, MetaConstants.BUTTON_ONLYICON, meta.isOnlyIcon(), false);
		DomHelper.writeAttr(element, MetaConstants.BUTTON_NEEDACCESSLOG, meta.getNeedAccessLog(), false);
		DomHelper.writeAttr(element, MetaConstants.BUTTON_NEEDAUTHENTICATE, meta.isNeedAuthenticate(), false);
		DomHelper.writeAttr(element, MetaConstants.BUTTON_CLICKANIM, meta.getClickAnim(), "");
		DomHelper.writeAttr(element, MetaConstants.BUTTON_UPLOADFILE, meta.isUploadFile(), false);
		DomHelper.writeAttr(element, MetaConstants.BUTTON_UPLOADTYPE, meta.getUploadType(), "single");
		DomHelper.writeAttr(element, MetaConstants.BUTTON_TYPE,ButtonType.toString(meta.getType()), "");
		DomHelper.writeAttr(element, MetaConstants.COMMON_ICON_CODE,meta.getIconCode(), "");
		DomHelper.writeAttr(element, MetaConstants.BUTTON_TCODE, meta.getTCode(), "");
		DomHelper.writeAttr(element, MetaConstants.BUTTON_ACTIVITY, meta.getActivity(), "");
		DomHelper.writeAttr(element, MetaConstants.COMMON_CHECK_ON_CLICK_NODE, meta.getCheckOnClickNode(), false);
	}

}
