package com.bokesoft.yes.meta.persist.dom.form.component.control.moduleeditor;

import org.w3c.dom.Document;
import org.w3c.dom.Element;

import com.bokesoft.yes.meta.persist.dom.BaseDomAction;
import com.bokesoft.yes.meta.persist.dom.form.MetaConstants;
import com.bokesoft.yigo.common.dom.DomHelper;
import com.bokesoft.yigo.meta.form.component.control.moduleeditor.MetaModuleItem;

public class MetaModuleItemAction extends BaseDomAction<MetaModuleItem> {

	@Override
	public void load(Document document, Element element, MetaModuleItem meta, int runType) {
		meta.setKey(DomHelper.readAttr(element, MetaConstants.COMMON_KEY, ""));
		meta.setCaption(DomHelper.readAttr(element, MetaConstants.COMMON_CAPTION, ""));
		meta.setImage(DomHelper.readAttr(element, MetaConstants.MODULEEDITOR_ITEM_IMAGE, ""));
		meta.setGroupValue(DomHelper.readAttr(element, MetaConstants.MODULEEDITOR_ITEM_GROUPVALUE, ""));
		meta.setGroupCaption(DomHelper.readAttr(element, MetaConstants.MODULEEDITOR_ITEM_GROUPCAPTION, ""));
	}

	@Override
	public void save(Document document, Element element, MetaModuleItem meta, int runType) {
		DomHelper.writeAttr(element, MetaConstants.COMMON_KEY, meta.getKey(), "");
		DomHelper.writeAttr(element, MetaConstants.COMMON_CAPTION, meta.getCaption(), "");
		DomHelper.writeAttr(element, MetaConstants.MODULEEDITOR_ITEM_IMAGE, meta.getImage(), "");
		DomHelper.writeAttr(element, MetaConstants.MODULEEDITOR_ITEM_GROUPVALUE, meta.getGroupValue(), "");
		DomHelper.writeAttr(element, MetaConstants.MODULEEDITOR_ITEM_GROUPCAPTION, meta.getGroupCaption(), "");
	}
}
