package com.bokesoft.yes.meta.persist.dom.form.component.control.listview;

import org.w3c.dom.Document;
import org.w3c.dom.Element;

import com.bokesoft.yes.meta.persist.dom.form.MetaConstants;
import com.bokesoft.yes.meta.persist.dom.form.component.control.editview.MetaEditViewAction;
import com.bokesoft.yigo.common.def.HAlignment;
import com.bokesoft.yigo.common.dom.DomHelper;
import com.bokesoft.yigo.meta.form.component.control.listview.MetaRotatorList;

public class MetaRotatorListAction extends MetaEditViewAction<MetaRotatorList> {
	@Override
	public void load(Document document, Element element, MetaRotatorList meta, int runType) {
		super.load(document, element, meta, runType);
		meta.setRowGap(DomHelper.readAttr(element, MetaConstants.TILEDLIST_ROWGAP, 0));
		meta.setCellGap(DomHelper.readAttr(element, MetaConstants.TILEDLIST_CELLGAP, 0));
		meta.setRowCount(DomHelper.readAttr(element, MetaConstants.ROTATORLIST_ROWCOUNT, MetaRotatorList.ROTATORLIST_DEFAULT_ROWCOUNT));
		meta.setColumnCount(DomHelper.readAttr(element, MetaConstants.COLUMNCOUNT, MetaRotatorList.ROTATORLIST_DEFAULT_COLUMNCOUNT));
		meta.setIndicator(DomHelper.readAttr(element, MetaConstants.GALLERY_INDICATOR, true));
		meta.setPagination(DomHelper.readAttr(element, MetaConstants.GALLERY_PAGINATION, false));
		meta.setIndicatorLocation(HAlignment.parse(DomHelper.readAttr(element, MetaConstants.GALLERY_INDICATOR_LOCATION, "")));
	}

	@Override
	public void save(Document document, Element element, MetaRotatorList meta, int runType) {
		super.save(document, element, meta, runType);
		DomHelper.writeAttr(element, MetaConstants.TILEDLIST_ROWGAP, meta.getRowGap(), 0);
		DomHelper.writeAttr(element, MetaConstants.TILEDLIST_CELLGAP, meta.getCellGap(), 0);
		DomHelper.writeAttr(element, MetaConstants.ROTATORLIST_ROWCOUNT, meta.getRowCount(), MetaRotatorList.ROTATORLIST_DEFAULT_ROWCOUNT);
		DomHelper.writeAttr(element, MetaConstants.COLUMNCOUNT, meta.getColumnCount(), MetaRotatorList.ROTATORLIST_DEFAULT_COLUMNCOUNT);
		DomHelper.writeAttr(element, MetaConstants.GALLERY_INDICATOR, meta.isIndicator(), true);
		DomHelper.writeAttr(element, MetaConstants.GALLERY_INDICATOR_LOCATION, HAlignment.toString(meta.getIndicatorLocation()), "");
		DomHelper.writeAttr(element, MetaConstants.GALLERY_PAGINATION, meta.isPagination(), false);
	}
}
