package com.bokesoft.yes.meta.persist.dom.form.component.control.editview;

import org.w3c.dom.Document;
import org.w3c.dom.Element;

import com.bokesoft.yes.meta.persist.dom.BaseDomAction;
import com.bokesoft.yes.meta.persist.dom.form.MetaConstants;
import com.bokesoft.yigo.common.def.ImageScaleType;
import com.bokesoft.yigo.common.dom.DomHelper;
import com.bokesoft.yigo.meta.form.component.control.editview.MetaEditViewItem;

public class MetaEditViewItemAction extends BaseDomAction<MetaEditViewItem> {

	@Override
	public void load(Document document, Element element, MetaEditViewItem meta, int runType) {
		meta.setKey(DomHelper.readAttr(element, MetaConstants.COMMON_KEY, ""));
		meta.setCaption(DomHelper.readAttr(element, MetaConstants.COMMON_CAPTION, ""));
		meta.setImage(DomHelper.readAttr(element, MetaConstants.PICTURE_IMAGE, ""));
		meta.setImageScaleType(ImageScaleType.parse(DomHelper.readAttr(element, MetaConstants.PICTURE_IMAGESCALETYPE, ImageScaleType.STR_FIT_XY)));
	}

	@Override
	public void save(Document document, Element element, MetaEditViewItem meta, int runType) {
		DomHelper.writeAttr(element, MetaConstants.COMMON_KEY, meta.getKey(), "");
		DomHelper.writeAttr(element, MetaConstants.COMMON_CAPTION, meta.getCaption(), "");
		DomHelper.writeAttr(element, MetaConstants.PICTURE_IMAGE, meta.getImage(), "");
		DomHelper.writeAttr(element, MetaConstants.PICTURE_IMAGESCALETYPE, ImageScaleType.toString(meta.getImageScaleType()), ImageScaleType.STR_FIT_XY);
	}
}
